<?php

/* Charge les scripts et les styles */
add_action( 'wp_enqueue_scripts', 'preguer_scripts' );
function preguer_scripts() {
    $version = wp_get_theme()->get( 'Version' );
    wp_enqueue_style( 'preguer-style', get_stylesheet_uri(), array(), $version );
}

/* Prise en charge de fonctions wp */
add_action( 'after_setup_theme', 'preguer_setup' );
function preguer_setup(){
    //add_theme_support( 'title-tag' );
	add_theme_support( 'post-thumbnails' );
	add_theme_support( 'html5', array( 'comment-list', 'comment-form', 'search-form', 'gallery', 'caption', 'style', 'script' ) );

// // Menus
    register_nav_menus(
        array(
            'menu-1' => ( 'Menu principal' ),
            'menu-2' => ( 'Menu mentions légales' ),
        )
    );	
}
/* Charge le le fichier de template tags personnalisés */
include 'inc/template-tags.php';

/* Ajoute un checkbox pour dérouler les sous-menus (Menu wp-cookbook) */
 add_filter( 'walker_nav_menu_start_el' , 'wpcookbook_nav_menu_start_el', 10, 4 );
/**
* Filters the menu item HTML
*
* @param string $output The menu item's starting HTML output.
* @param WP_Post $item The current menu item.
* @param int $depth Depth of menu item. Used for padding.
* @param array $args An object of wp_nav_menu() arguments.
* @return $output The menu item's final HTML output.
*/
function wpcookbook_nav_menu_start_el( $output, $item, $depth, $args ){
$idmenu = $item->ID ;	
if( in_array( 'menu-item-has-children', $item->classes, true ) ) {
$output .= '<input type="checkbox" id="checkbox-'.$idmenu.'" class="sous-menu-checkbox"><label for="checkbox-'.$idmenu.'" class="sous-menu-label screen-reader-text">Sous-menu</label>
';
    }
return $output;
    }


/*Supprime les titres des widgets */
add_filter('widget_title', 'remove_widget_title');
function remove_widget_title() {
return;
}


/* Personnnalise les titres des pages d'archive */
function reguer_modifier_titre_archive( $title, $original_title, $prefix ) {
	//wp_var_dump( $original_title );
	if ( is_category() ) {
		// composer le nouveau titre  
		$title = $original_title;
	}	
	if ( is_tag() ) {
		// composer le nouveau titre  
		$title = sprintf( '<span class="surtitre">Voir tous les articles à propos de<br></span> %1$s', $original_title );
	}
	return $title;
}
add_filter( 'get_the_archive_title', 'reguer_modifier_titre_archive', 10, 3 );



/** Fonction pour virer jquery **/
add_filter( 'wp_enqueue_scripts', 'change_default_jquery', PHP_INT_MAX );

function change_default_jquery( ){
    wp_dequeue_script( 'jquery');
    wp_deregister_script( 'jquery');   
}
/** Enlever les couleurs personnalisees **/

add_theme_support( 'disable-custom-colors' );


/** Ajouter un champ Description (code ACF exporté de Cuisine à l'Ouest) **/
add_action( 'acf/include_fields', function() {
	if ( ! function_exists( 'acf_add_local_field_group' ) ) {
		return;
	}

	acf_add_local_field_group( array(
	'key' => 'group_5daffef307b80',
	'title' => 'Référencement',
	'fields' => array(
		array(
			'key' => 'field_5dafff047017f',
			'label' => 'Description',
			'name' => 'description_seo',
			'aria-label' => '',
			'type' => 'textarea',
			'instructions' => 'Balise description',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'placeholder' => '',
			'maxlength' => '',
			'rows' => '',
			'new_lines' => '',
		),
	),
	'location' => array(
		array(
			array(
				'param' => 'post_type',
				'operator' => '==',
				'value' => 'post',
			),
		),
		array(
			array(
				'param' => 'post_type',
				'operator' => '==',
				'value' => 'recipe',
			),
		),
		array(
			array(
				'param' => 'post_type',
				'operator' => '==',
				'value' => 'page',
			),
		),
	),
	'menu_order' => 0,
	'position' => 'side',
	'style' => 'default',
	'label_placement' => 'top',
	'instruction_placement' => 'label',
	'hide_on_screen' => array(
		0 => 'discussion',
	),
	'active' => true,
	'description' => 'Référencement',
	'show_in_rest' => false,
) );
} );