<?php
/**
 * Template part for displaying a message that posts cannot be found
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package underscores
 */

?>

<section class="no-results not-found">
	<header class="page-header">
				<h1 class="page-title">Que recherchez-vous ?</h1>
			</header><!-- .page-header -->

			<div class="page-content">
				<p>La page que vous avez demandée n‘existe pas , ou n‘existe plus. Voici quelques pistes pour vous aider à trouver ce que vous cherchez.  </p>

					<?php
					get_search_form();

					the_widget( 'WP_Widget_Recent_Posts' );
					?>

					<div class="widget widget_categories">
						<h2 class="widget-title">Les catégories les plus visitées</h2>
						<ul>
							<?php
							wp_list_categories(
								array(
									'orderby'    => 'count',
									'order'      => 'DESC',
									'show_count' => 1,
									'title_li'   => '',
									'number'     => 10,
								)
							);
							?>
						</ul>
					</div><!-- .widget -->

					
					<h2>Essayez de chercher dans nos archives mensuelles</h2>
					<?php	
					the_widget( 'WP_Widget_Archives' );
					?>
					<h2> Ou choisissez un mot-clé</h2>	
					<?php
					the_widget( 'WP_Widget_Tag_Cloud' );
					?>

			</div><!-- .page-content -->
</section><!-- .no-results -->
