<?php

add_action( 'wp_enqueue_scripts', 'theme_enqueue_styles' );
function theme_enqueue_styles() {
    wp_enqueue_style( 'parent-style', get_template_directory_uri() . '/style.css' );

}


/* Activer le support des catégories pour les pages */
function wpc_cat_pages() {
	register_taxonomy_for_object_type('category', 'page');
}
add_action('init', 'wpc_cat_pages');

// Ajouter des boutons à l'éditeur Tiny MCE
function my_mce_buttons_2( $buttons ) {	
	/**
	 * Add in a core button that's disabled by default
	 */
	$buttons[] = 'superscript';
	$buttons[] = 'subscript';

	return $buttons;
}
add_filter( 'mce_buttons_2', 'my_mce_buttons_2' );


//Retreive Blog Page Editor - Ajoute un bloc d'édition sur la page blog

function jst_starter_retreive_editor( $post )
{
	if( isset( $post ) && get_option( 'page_for_posts' ) != $post->ID )
	{
		return false;
	}
	add_post_type_support( 'page', 'editor' );
}
add_action( 'edit_form_after_title', 'jst_starter_retreive_editor', 10 );