<div class="wrap about-wrap full-width-layout">
  <p class="<?php
  if (is_array($accounts) && count($accounts)) {
    echo 'qligg-premium-field';
  }
  ?>">
    <a id="qligg-generate-token" target="_self" href="<?php echo esc_url($qligg_api_v2->getAccessTokenLink()); ?>" title="<?php esc_html_e('Add New Account', 'insta-gallery'); ?>">
      <?php esc_html_e('Add New Account', 'insta-gallery'); ?>
    </a>
    <span style="float: none; margin-top: 0;" class="spinner"></span>
    <a id="qligg-add-token" href="javascript:;"><?php esc_html_e('Button not working?', 'insta-gallery'); ?></a>
    <span class="description hidden"><small><?php esc_html_e('(This is a premium feature).', 'insta-gallery'); ?></small></span>
  </p>

  <?php if (is_array($accounts) && count($accounts)) : ?>
    <table id="qligg_account_table" class="form-table widefat striped">
      <thead>
        <tr>
          <th><?php esc_html_e('Image', 'insta-gallery'); ?></th>
          <th><?php esc_html_e('User', 'insta-gallery'); ?></th>
          <th><?php esc_html_e('ID', 'insta-gallery'); ?></th>
          <th><?php esc_html_e('Name', 'insta-gallery'); ?></th>
          <th><?php esc_html_e('Type', 'insta-gallery'); ?></th>
          <th><?php esc_html_e('Token', 'insta-gallery'); ?></th>
          <th><?php esc_html_e('Expires', 'insta-gallery'); ?></th>
          <th><?php esc_html_e('Action', 'insta-gallery'); ?></th>
        </tr>
      </thead>
      <tbody>
        <?php
        foreach ($accounts as $account_id => $account) {

          $profile_info = qligg_get_user_profile($account_id);
          ?>
          <tr class="<?php echo esc_attr(strtolower($profile_info['account_type'])); ?>" data-account_id="<?php echo esc_attr($account_id) ?>">
            <td width="1%">
              <img class="qligg-avatar" src="<?php echo esc_url($profile_info['profile_pic_url']); ?>" />
            </td>
            <td>
              <?php echo esc_html($profile_info['id']); ?>
            </td>
            <td>
              <?php echo esc_html($profile_info['username']); ?>
            </td>
            <td>
              <?php echo esc_html($profile_info['full_name']); ?>
            </td>
            <td>
              <?php echo esc_html($account['account_type']); ?>
            </td>
            <td>
              <input type="hidden" name="account_id" value="<?php echo esc_attr($account_id); ?>"> 
              <input id="<?php echo esc_attr($account_id); ?>-access-token" type="text" value="<?php echo esc_attr($account['access_token']); ?>" readonly />
            </td>
            <td>
              <?php echo esc_html(date('Y-m-d', (int) $account['expiration_date'])); ?>
            </td>
            <td>
              <a href="javascript:;" data-qligg-copy-token="#<?php echo esc_attr($account_id); ?>-access-token" class="button button-primary">
                <i class="dashicons dashicons-edit"></i><?php esc_html_e('Copy', 'insta-gallery'); ?>
              </a>
              <a href="javascript:;" data-qligg-delete-token="<?php echo esc_attr($account_id); ?>" class="button button-secondary">
                <i class="dashicons dashicons-trash"></i><?php esc_html_e('Delete', 'insta-gallery'); ?>
              </a>
              <span class="spinner"></span>
            </td>
          </tr>
          <?php
        }
        ?>
      </tbody>
    </table> 
  <?php endif; ?>
</div>

<?php include_once('modals/template-scripts-account.php'); ?> 