<?php

include_once(QLIGG_PLUGIN_DIR . 'includes/models/Token.php');
include_once(QLIGG_PLUGIN_DIR . 'includes/models/Setting.php');

function qligg_sanitize_instagram_feed($feed) {

  global $qligg_api_v2;

  // Removing @, # and trimming input
  // ---------------------------------------------------------------------

  $feed = sanitize_text_field($feed);

  $feed = trim($feed);
  $feed = str_replace('@', '', $feed);
  $feed = str_replace('#', '', $feed);
  $feed = str_replace($qligg_api_v2->instagram_url, '', $feed);
  $feed = str_replace('/explore/tags/', '', $feed);
  $feed = str_replace('/', '', $feed);

  return $feed;
}

// Return user profile
// -----------------------------------------------------------------------------
function qligg_get_user_profile($account_id = null) {

  global $qligg_api_v2, $qligg_api;

  $defaults = array(
      'id' => $account_id,
      'type' => '',
      'account_type' => '',
      'username' => 'Unknow',
      'full_name' => '',
      'profile_pic_url' => 'http://2.gravatar.com/avatar/b642b4217b34b1e8d3bd915fc65c4452?s=150&d=mm&r=g',
      'profile_pic_url_hd' => 'http://2.gravatar.com/avatar/b642b4217b34b1e8d3bd915fc65c4452?s=320&d=mm&r=g',
      'link' => ''
  );

  if (empty($account_id)) {
    return $defaults;
  }

  $account_model = new QLIGG_Account();

  if (!$account = $account_model->get_account($account_id)) {
    return $defaults;
  }

  $tk = "insta_gallery_v2_user_profile_{$account_id}"; // transient key

  if (!QLIGG_DEVELOPER && false !== ($profile_info = get_transient($tk))) {
    return wp_parse_args($profile_info, $defaults);
  }

  if (!$account['access_token']) {
    return $defaults;
  }
  //1326
  //detect token type old || new
  //validate token based on type

  if ($account['account_type'] === 'BASIC') {

    $_profile_info = $qligg_api->get_user_profile($account['access_token']);

    $defaults['account_type'] = $account['account_type'];
    $defaults['username'] = $_profile_info['username'];
    $defaults['full_name'] = __('This token expires soon!');
    $defaults['profile_pic_url'] = $_profile_info['profile_picture'];
    $defaults['profile_pic_url_hd'] = $_profile_info['profile_picture'];

    return $defaults;
  }

  $_profile_info = $qligg_api_v2->getUserProfile($account['access_token']);

  $_profile_info['link'] = "{$qligg_api_v2->instagram_url}/{$account['username']}";

  if (isset($_profile_info['username'])) {

    if (false !== ($html = @file_get_contents("https://www.instagram.com/{$_profile_info['username']}/"))) {

      $pattern = '/"full_name":"(.+?)"/';
      preg_match($pattern, $html, $full_name);
      if (isset($full_name[1])) {
        $_profile_info['full_name'] = $full_name[1];
      }

      $pattern = '/"profile_pic_url":"(.+?)"/';
      preg_match($pattern, $html, $profile_pic_url);
      if (isset($profile_pic_url[1])) {
        $_profile_info['profile_pic_url'] = str_replace('\u0026', '&', $profile_pic_url[1]);
      }

      $pattern = '/"profile_pic_url_hd":"(.+?)"/';
      preg_match($pattern, $html, $profile_pic_url_hd);
      if (isset($profile_pic_url_hd[1])) {
        $_profile_info['profile_pic_url_hd'] = str_replace('\u0026', '&', $profile_pic_url_hd[1]);
      }
    }
  }

  $settings_model = new QLIGG_Setting();
  $settings = $settings_model->get_settings();

  $profile_info = wp_parse_args($_profile_info, $defaults);

  set_transient($tk, $profile_info, absint($settings['insta_reset']) * HOUR_IN_SECONDS);


  return $profile_info;
}

// Return tag info
// -----------------------------------------------------------------------------
function qligg_get_tag_profile($hashtag = null) {

  global $qligg_api_v2;

  $defaults = array(
      'id' => '',
      'account_type' => 'TAG',
      'username' => $hashtag,
      'full_name' => $hashtag,
      'profile_pic_url' => 'http://2.gravatar.com/avatar/b642b4217b34b1e8d3bd915fc65c4452?s=150&d=mm&r=g',
      'profile_pic_url_hd' => 'http://2.gravatar.com/avatar/b642b4217b34b1e8d3bd915fc65c4452?s=320&d=mm&r=g',
      'link' => "{$qligg_api_v2->instagram_url}/explore/tags/{$hashtag}"
  );

  if (empty($hashtag)) {
    return $defaults;
  }

  $tk = "insta_gallery_v2_tag_profile_{$hashtag}"; // transient key

  if (!QLIGG_DEVELOPER && false !== ($profile_info = get_transient($tk))) {
    return wp_parse_args($profile_info, $defaults);
  }

  if (!$hashtag_id = $qligg_api_v2->getTagId($hashtag)) {
    return $defaults;
  }

  $_profile_info = array();

  $_profile_info['id'] = $hashtag_id;

  if (false !== ($html = @file_get_contents("{$qligg_api_v2->instagram_url}/explore/tags/{$hashtag}"))) {

    $pattern = '/"profile_pic_url":"(.+?)"/';
    preg_match($pattern, $html, $profile_pic_url);
    if (isset($profile_pic_url[1])) {
      $_profile_info['profile_pic_url'] = str_replace('\u0026', '&', $profile_pic_url[1]);
    }

    $pattern = '/"profile_pic_url_hd":"(.+?)"/';
    preg_match($pattern, $html, $profile_pic_url_hd);
    if (isset($profile_pic_url_hd[1])) {
      $_profile_info['profile_pic_url_hd'] = str_replace('\u0026', '&', $profile_pic_url_hd[1]);
    }
  }

  $profile_info = wp_parse_args($_profile_info, $defaults);
  $settings_model = new QLIGG_Setting();
  $settings = $settings_model->get_settings();

  set_transient($tk, $profile_info, absint($settings['insta_reset']) * HOUR_IN_SECONDS);

  return $profile_info;
}

// Get user feed
// -----------------------------------------------------------------------------
function qligg_get_user_media($account_id = null, $limit = 12, $last_id = null, $after = null) {

  global $qligg_api_v2, $qligg_api;

  if (!$account_id) {
    $qligg_api_v2->setMessage(esc_html__('Please update Instagram User in the feed settings.', 'insta-gallery'));
    return;
  }

  $account_model = new QLIGG_Account();

//  error_log($account_id);

  $account = $account_model->get_account($account_id);

//  error_log(json_encode($account));

  if (!isset($account['access_token'])) {
    $qligg_api_v2->setMessage(esc_html__('Please update Instagram Access Token in the account settings.', 'insta-gallery'));
    return;
  }

  // compatibility with 2.7.1
  // ---------------------------------------------------------------------------
  if ($account['account_type'] === 'BASIC' && $qligg_api->validate_token($account['access_token'])) {
    return qligg_get_user_items_old($account_id, $limit, $last_id, $after);
  }

  $tk = "insta_gallery_v2_user_media_{$account_id}_{$after}";

  // Get any existing copy of our transient data
  if (QLIGG_DEVELOPER || false === ($response = get_transient($tk))) {

    $response = $qligg_api_v2->getUserMedia($account['access_token'], $after);

    if (!isset($response['data'])) {
      return;
    }

    if (!count($response['data'])) {
      return;
    }

    $settings_model = new QLIGG_Setting();
    $settings = $settings_model->get_settings();

    set_transient($tk, $response, absint($settings['insta_reset']) * HOUR_IN_SECONDS);
  }

  $feeds = $qligg_api_v2->setupMediaItems($response['data'], $last_id);

  if (!$last_id) {
    return $feeds;
  }

  if (count($feeds) >= $limit) {
    return $feeds;
  }

  if (!isset($response['paging']['next'])) {
    return $feeds;
  }

  if (!isset($response['paging']['cursors']['after'])) {
    return $feeds;
  }

  $after = $response['paging']['cursors']['after'];

  return array_merge($feeds, qligg_get_user_media($account_id, $limit, $last_id, $after));
}

// Get tag items
// -----------------------------------------------------------------------------
function qligg_get_tag_items($hashtag = null, $limit = 12, $last_id = null, $after = null) {

  global $qligg_api_v2;

  if (!$hashtag) {
    $qligg_api_v2->setMessage(esc_html__('Please update Instagram Tag in the feed settings.', 'insta-gallery'));
    return;
  }

  $tk = "insta_gallery_v2_tag_media_{$hashtag}_{$after}";

  // Get any existing copy of our transient data
  if (QLIGG_DEVELOPER || false === ($response = get_transient($tk))) {

    $response = $qligg_api_v2->getTagMedia($hashtag, $after);

    if (!isset($response['data'])) {
      return;
    }

    if (!count($response['data'])) {
      return;
    }

    $settings_model = new QLIGG_Setting();
    $settings = $settings_model->get_settings();

    set_transient($tk, $response, absint($settings['insta_reset']) * HOUR_IN_SECONDS);
  }

  $feeds = $qligg_api_v2->setupMediaItems($response['data'], $last_id);

  if (!$last_id) {
    return $feeds;
  }

  if (count($feeds) >= $limit) {
    return $feeds;
  }

  if (!isset($response['paging']['next'])) {
    return $feeds;
  }

  if (!isset($response['paging']['cursors']['after'])) {
    return $feeds;
  }

  $after = $response['paging']['cursors']['after'];

  return array_merge($feeds, qligg_get_tag_items($hashtag, $limit, $last_id, $after));
}
