<?php

if (!defined('ABSPATH'))
  exit;

if (!class_exists('QLIGG_API_V2')) {

  class QLIGG_API_V2 {

    public $message;
    public $instagram_url = 'https://www.instagram.com';
    private $redirect_uri = 'https://socialfeed.quadlayers.com/index.php';
    private $app_id = '504270170253170';
    private $instagram_graph_url = 'https://graph.instagram.com';
    private $facebook_graph_url = 'https://graph.facebook.com';

    function getAccessTokenLink() {

      $state = admin_url('admin.php');
      $scope = 'user_profile,user_media';

      return "{$this->instagram_url}/oauth/authorize?app_id={$this->app_id}&redirect_uri={$this->redirect_uri}&response_type=code&scope={$scope}&state={$state}";
    }

    function getUserProfile($access_token) {

      $response = $this->remoteGet("{$this->instagram_graph_url}/me", array(
          'fields' => 'id,media_count,username,account_type',
          'access_token' => $access_token
      ));

      return (array) $response;
    }

    function getTagId($hashtag = null) {

      $access_token = 'EAADnl4w17Q8BADxdb3m8fovoCkoV59KSc70PlsidDrIXRcMFM2qlvMVYaIUztm1xg2noIkoxtsT0SkMdOpbiZCahiXg9oYqDrZCdziY4LwZBgWoB8UU5AxsLlyVgafZC0ilWwIMOe1iO8BQa9aJAv1BXW554kMIZD';
      $account_id = '17841403829892188';

      $response = $this->remoteGet("{$this->facebook_graph_url}/ig_hashtag_search", array(
          'user_id' => $account_id,
          'q' => urlencode($hashtag),
          'access_token' => $access_token
      ));

      if (isset($response['data'][0]['id'])) {
        return $response['data'][0]['id'];
      }
    }

    function getTagMedia($hashtag = null, $after = null) {

      if ($hashtag_id = $this->getTagId($hashtag)) {

        $access_token = 'EAADnl4w17Q8BADxdb3m8fovoCkoV59KSc70PlsidDrIXRcMFM2qlvMVYaIUztm1xg2noIkoxtsT0SkMdOpbiZCahiXg9oYqDrZCdziY4LwZBgWoB8UU5AxsLlyVgafZC0ilWwIMOe1iO8BQa9aJAv1BXW554kMIZD';
        $account_id = '17841403829892188';

        $limit = 60; //$num = min( $num, 200 );
        $order_by = 'recent_media'; //top_media

        $response = $this->remoteGet("{$this->facebook_graph_url}/{$hashtag_id}/{$order_by}", array(
            'after' => $after,
            'user_id' => $account_id,
            'limit' => $limit,
            'fields' => 'media_url,caption,id,media_type,comments_count,like_count,permalink,children{media_url,id,media_type,permalink}',
            'access_token' => $access_token
        ));

        return (array) $response;
      }
    }

    function getUserMedia($access_token, $after = null) {

      $limit = 60; //$num = min( $num, 200 );

      $response = $this->remoteGet("{$this->instagram_graph_url}/me/media", array(
          'after' => $after,
          'limit' => $limit,
          'fields' => 'media_url,thumbnail_url,caption,id,media_type,timestamp,username,comments_count,like_count,permalink,children{media_url,id,media_type,timestamp,permalink,thumbnail_url}',
          'access_token' => $access_token
      ));

//      error_log('$response: ' . json_encode($response, JSON_PRETTY_PRINT));

      return (array) $response;
    }

    function setupMediaItems($data, $last_id = null) {

      static $load = false;
      static $i = 1;

      if (!$last_id) {
        $load = true;
      }

      $instagram_items = array();

      if (is_array($data) && !empty($data)) {

        foreach ($data as $item) {

          if ($load) {

            preg_match_all("/#(\\w+)/", @$item['caption'], $hashtags);

            $media_url = ($item['media_type'] === 'CAROUSEL_ALBUM') ? @$item['children']['data'][0]['media_url'] : @$item['media_url'];
//            error_log(json_encode($item, JSON_PRETTY_PRINT));
            $date = isset($item['timestamp']) ? date_i18n('j F, Y', strtotime(trim(str_replace(array('T', '+', ' 0000'), ' ', $item['timestamp'])))) : false;

            $instagram_items[] = array(
                'i' => $i,
                'id' => $item['id'],
                'type' => strtolower(str_replace('_ALBUM', '', $item['media_type'])),
                'media' => $media_url,
                'images' => array(
                    'standard' => "{$item['permalink']}media?size=l",
                    'medium' => "{$item['permalink']}media?size=m",
                    'small' => "{$item['permalink']}media?size=t",
                ),
                'videos' => array(
                    'standard' => "{$item['permalink']}media?size=l",
                    'medium' => "{$item['permalink']}media?size=m",
                    'small' => "{$item['permalink']}media?size=t",
                ),
                'likes' => isset($item['like_count']) ? $item['like_count'] : false,
                'comments' => isset($item['comments_count']) ? $item['comments_count'] : false,
                'caption' => preg_replace('/(?<!\S)#([0-9a-zA-Z]+)/', "<a href=\"{$this->instagram_url}/explore/tags/$1\">#$1</a>", htmlspecialchars(@$item['caption'])),
                'hashtags' => @$hashtags[1],
                'link' => $item['permalink'],
//                'user_id' => @$item['user']['id'],
                'date' => $date
            );
          }
          if ($last_id && ($last_id == $i)) {
            $i = $last_id;
            $load = true;
          }
          $i++;
        }
      }

      return $instagram_items;
    }

    function validateResponse($json = null) {

      if (!($response = json_decode(wp_remote_retrieve_body($json), true)) || 200 !== wp_remote_retrieve_response_code($json)) {

        if (isset($response['error']['message'])) {
          $this->message = $response['error']['message'];
          return array(
              'error' => 1,
              'message' => $this->message
          );
        }

        if (is_wp_error($json)) {
          $response = array(
              'error' => 1,
              'message' => $json->get_error_message()
          );
        } else {
          $response = array(
              'error' => 1,
              'message' => esc_html__('Unknow error occurred, please try again', 'insta-gallery')
          );
        }
      }

      return $response;
    }

    public function remoteGet($url = null, $args = array()) {

      $url = add_query_arg($args, trailingslashit($url));

//      error_log($url);

      $response = $this->validateResponse(wp_remote_get($url, array('timeout' => 29)));

      return $response;
    }

    // Return message
    // ---------------------------------------------------------------------------
    public function getMessage() {
      return $this->message;
    }

    public function setMessage($message = '') {
      $this->message = $message;
    }

  }

}
