<?php

include_once(QLIGG_PLUGIN_DIR . 'includes/models/Account.php');
include_once(QLIGG_PLUGIN_DIR . 'includes/controllers/QLIGG_Controller.php');

class QLIGG_Account_Controller extends QLIGG_Controller {

  protected static $instance;
  protected static $slug = 'qligg_account';

//  protected static $slug = QLIGG_DOMAIN . '_account';

  public static function instance() {
    if (!isset(self::$instance)) {
      self::$instance = new self();
      self::$instance->init();
    }
    return self::$instance;
  }

  function init() {
    add_action('wp_ajax_qligg_add_account', array($this, 'ajax_add_account'));
    add_action('wp_ajax_qligg_delete_account', array($this, 'ajax_delete_account'));
    add_action('admin_enqueue_scripts', array($this, 'add_js'));
    add_action('admin_menu', array($this, 'add_menu'));
  }

  function add_menu() {
    add_submenu_page(QLIGG_DOMAIN, esc_html__('Accounts', 'insta-gallery'), esc_html__('Accounts', 'insta-gallery'), 'manage_options', self::$slug, array($this, 'add_panel'));
  }

  function add_panel() {
    global $submenu, $qligg_api_v2;
    $account_model = new QLIGG_Account();
    $accounts = $account_model->get_accounts();

    include (QLIGG_PLUGIN_DIR . '/includes/view/backend/pages/parts/header.php');
    include (QLIGG_PLUGIN_DIR . '/includes/view/backend/pages/accounts.php');
  }

  function ajax_add_account() {

//    global $qligg_api_v2;

    if (!empty($_REQUEST) && current_user_can('manage_options') && check_ajax_referer('qligg_add_account', 'nonce', false)) {

      if (empty($_REQUEST['account_data']['id'])) {
        parent::error_ajax(esc_html__('Empty access account', 'insta-gallery'));
      }

      $account_data = $_REQUEST['account_data'];
      $account_model = new QLIGG_Account();
      $accounts = $account_model->get_accounts();

      $account_model->add_account($account_data);

      if (isset($accounts[$account_data['id']])) {// && $accounts[$account_data['id']] == $account_data) {
        parent::error_ajax(esc_html__('Account already connected. To connect a new account logout from Instagram in this browser.', 'insta-gallery'));
      }

      parent::success_ajax(esc_html__('Access account created', 'insta-gallery'));
    }

    parent::error_access_denied();
  }

  function ajax_delete_account() {

    if (!empty($_REQUEST['account_id']) && current_user_can('manage_options') && check_ajax_referer('qligg_delete_account', 'nonce', false)) {

      $account_model = new QLIGG_Account();

      $account_id = sanitize_text_field($_REQUEST['account_id']);
//
//      error_log($account_id);

      $account_model->delete_account($account_id);

      parent::success_ajax(esc_html__('Account removed successfully', 'insta-gallery'));
    }

    parent::error_access_denied();
  }

  function add_js() {

    wp_register_script('qligg-admin-account', plugins_url('/assets/backend/js/qligg-admin-account' . QLIGG::is_min() . '.js', QLIGG_PLUGIN_FILE), array('wp-util', 'jquery', 'backbone', 'jquery-serializejson'), QLIGG_PLUGIN_VERSION, true);
    wp_localize_script('qligg-admin-account', 'qligg_account', array(
        'nonce' => array(
            'qligg_add_account' => wp_create_nonce('qligg_add_account'),
            'qligg_delete_account' => wp_create_nonce('qligg_delete_account'),
        ),
        'message' => array(
            'confirm_delete' => __('Do you want to delete the account?', 'insta-gallery')
        )
    ));

    if (isset($_GET['page']) && ($_GET['page'] === self::$slug)) {
      wp_enqueue_script('qligg-admin-account');
      wp_enqueue_style('qligg-admin');
    }
  }

}

QLIGG_Account_Controller ::instance();
