<?php

add_action( 'wp_enqueue_scripts', 'theme_enqueue_styles' );
function theme_enqueue_styles() {
    wp_enqueue_style( 'parent-style', get_template_directory_uri() . '/style.css' );

}


/**
Enlever la barre d'administration
 */
function my_function_admin_bar(){
    return false;
}
add_filter( 'show_admin_bar' , 'my_function_admin_bar');

// Add images sizes.
function custom_theme_setup() {
    add_image_size( 'largeur-site', 800, 800 );

}
add_action( 'after_setup_theme', 'custom_theme_setup' );
 
// Make custom sizes selectable from WordPress admin.
function custom_image_sizes( $size_names ) {
    $new_sizes = array(
        'largeur-site' => __( 'largeur site', 'generatewp.com' ),

    );
    return array_merge( $size_names, $new_sizes );
}
add_filter( 'image_size_names_choose', 'custom_image_sizes' );

// FIN Add images sizes.

// Changer la largeur de l'éditeur (ajouter un css)
function my_theme_setup() {
  	
  	add_theme_support('editor-styles');
	add_editor_style( 'style-editor.css' );
   
}
add_action( 'after_setup_theme', 'my_theme_setup' );

// FIN Changer la largeur de l'éditeur



// SUPPRIMER LE MENU MOBILE
add_action( 'wp_enqueue_scripts', 'theme_remove_scripts', 20 );
function theme_remove_scripts(){
        wp_dequeue_script( 'alouest-navigation' );
}

// Ajouter des extraits aux pages
add_action( 'admin_init', create_function('', "return add_post_type_support( 'page', 'excerpt' );") );


