<?php
/**
 * The header for our theme vdaube-child
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package alouest
 */

?>
<!doctype html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="https://gmpg.org/xfn/11">

	<?php wp_head(); ?>
	 <link href="https://fonts.googleapis.com/css2?family=Source+Sans+Pro:ital,wght@0,300;0,700;1,300;1,700&display=swap" rel="stylesheet">  
	
<!-- Global site tag (gtag.js) - Google Analytics -->
<script async src="https://www.googletagmanager.com/gtag/js?id=UA-151317560-2"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());

  gtag('config', 'UA-151317560-2');
</script>

	
</head>

<body <?php body_class(); ?>>
<div id="page" class="site">
	<a class="skip-link screen-reader-text" href="#content"><?php esc_html_e( 'Skip to content', 'alouest' ); ?></a>

	<header id="masthead" class="site-header">
		<div class="site-branding">
		  <section class="nom-du-site">
				<h1 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home">valérie <span class="gras">daubé</span></a></h1>
				<p class="site-description">artiste plasticienne</p>
		 </section> <!-- fin nom-du-site-->
		 <section class="reseaux-sociaux">       
               <a id="picto-facebook" href="https://www.facebook.com/valerie.daube.3">
                <img src="<?php echo get_stylesheet_directory_uri(); ?>/img/picto-facebook-rouge.svg" alt="Facebook" onerror="this.removeAttribute('onerror'); this.src='https://valeriedaube.com/wp-content/themes/vdaube-child/img/picto-facebook-rouge.png'"/>
               </a> 
               <a id="picto-insta-rouge" href="https://www.instagram.com/valeriedaube/">
                <img src="<?php echo get_stylesheet_directory_uri(); ?>/img/picto-insta-rouge.svg" alt="Instagram" onerror="this.removeAttribute('onerror'); this.src='https://valeriedaube.com/wp-content/themes/vdaube-child/img/picto-insta-rouge.png'"/>
               </a> 
               <a id="picto-mail" href="mailto:pierre.reguer@yahoo.fr">
                <img src="<?php echo get_stylesheet_directory_uri(); ?>/img/picto-mail-rouge.svg" alt="email" onerror="this.removeAttribute('onerror'); this.src='https://valeriedaube.com/wp-content/themes/vdaube-child/img/picto-mail-rouge.png'"/>
               </a> 
		 </section> <!-- fin reseaux-sociaux-->

		</div><!-- .site-branding -->

		
		
			
		<nav id="site-navigation" class="main-navigation">
			<!-- bouton menu par défaut d'Underscores supprimer ce button pour le saquer	
			<button class="menu-toggle" aria-controls="primary-menu" aria-expanded="false"><?php esc_html_e( 'Primary Menu', 'alouest' ); ?></button>
			-->
			
			<?php
			wp_nav_menu( array(
				'theme_location' => 'menu-1',
				'menu_id'        => 'primary-menu',
			) );
			?>
		</nav><!-- #site-navigation -->
		
	</header><!-- #masthead -->
	

	<?php if ( is_front_page() ) {
				echo "<div class='pleine-largeur'>";
                echo do_shortcode('[metaslider id="59"]');
                echo "</div>";
                } 
         elseif ( is_home() ) {
                }
         elseif ( is_single() ) {
                }              
	     else {
		
		echo "<!-- Appel au post thumbnail pour l'afficher comme bandeau -->";

	    echo "<div id='bandeau2' class='pleine-largeur'>";

              if(have_posts()) {
                 while (have_posts()) : the_post();
                 the_post_thumbnail();  
                 endwhile; 
	                       }
	   echo "</div>";    
	     }

       ?>
<!-- FIN Appel au post thumbnail pour l'afficher comme bandeau -->
    
		



	<div id="content" class="site-content">
