<?php
/**
 * Template part for displaying page content 2 colonnes dans le modèle de page 2 colonnes
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package taule-underscores -theme enfant
 */

?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<header class="entry-header">
		<?php the_title( '<h1 class="entry-title">', '</h1>' ); ?>
	</header><!-- .entry-header -->

	<div class="entry-content colonne-gauche">
		<?php
			the_content();

			wp_link_pages( array(
				'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'taule-underscores' ),
				'after'  => '</div>',
			) );
		?>
	</div><!-- .entry-content -->
	<div class="colonne-droite">
	    <?php the_field('colonne-de-droite'); ?>
	</div> <!-- ferme colonne-droite -->
	<div style="clear: both;"></div>

	<?php if ( get_edit_post_link() ) : ?>
		<footer class="entry-footer">
			<?php
				edit_post_link(
					sprintf(
						wp_kses(
							/* translators: %s: Name of current post. Only visible to screen readers */
							__( 'Edit <span class="screen-reader-text">%s</span>', 'taule-underscores' ),
							array(
								'span' => array(
									'class' => array(),
								),
							)
						),
						get_the_title()
					),
					'<span class="edit-link">',
					'</span>'
				);
			?>
		</footer><!-- .entry-footer -->
	<?php endif; ?>
</article><!-- #post-<?php the_ID(); ?> -->
