<?php
/**
 * Template part for displaying posts
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package pierre17 - template pour la page d'accueil en dur
 */

?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

    <div class="entry-content colonne-gauche-accueil">
        
        <?php
        //Appel du custom post infos mot d'accueil
        $id = 721;
        $mot_accueil = get_post($id);
        $title = $mot_accueil->post_title;
        $contenu = $mot_accueil->post_content;
        $contenu = apply_filters('the_content', $contenu);
        $contenu = str_replace(']]>', ']]&gt;', $contenu);
        ?>
        <?php echo "<h1>$title</h1>$contenu"; ?>
        


    </div><!-- .entry-content colonne-gauche-accueil-->
	

    <div class="colonne2sur3">

          <?php    
          // Appel des articles de catégorie 13 (accueil-culture)    
          $args = array( 'cat' =>13, 'posts_per_page' => 10 );
          $loop = new WP_Query( $args );
          while ( $loop->have_posts() ) : $loop->the_post();
          echo '<div class="encadre-culture">
                  <h2>Vie culturelle</h2>
                      <h3>';  
          the_title();
          echo '
                      </h3> ';
          the_post_thumbnail( 'medium' );         
          the_excerpt();          
          echo '<p class="lirelasuite"><a href="'; 
          the_permalink();
          echo '">Lire la suite</a></p></div> <!-- ferme encadre-culture -->';           
          endwhile;
          ?>
        

<!-- Shortcode slider actus-->
        <div class="encadre-actus">
            <h2>Actus</h2>
            <?php echo do_shortcode( '[su_slider source="category: 5" limit="5" link="post" width="500" height="360" mousewheel="no" autoplay="8000" speed="300" pages="no" class="petit-slider-actu"]' );
		?>
        </div> <!-- ferme encadré-actus-->



          <?php
          //Appel du custom post infos Travaux
          $id = 539;
          $travaux = get_post($id);
          $title = $travaux->post_title;
          $contenu = $travaux->post_content;
          $contenu = apply_filters('the_content', $contenu);
          $contenu = str_replace(']]>', ']]&gt;', $contenu);
          ?>
           <?php
          if(!empty($contenu)) {
          	echo "<div class=\"encadre-travaux\"><h2>$title</h2>$contenu</div> <!-- ferme encadre-travaux -->"	;
          }
          ?> 


    </div> <!-- ferme colonne2sur3 -->
    
    <div class="colonne3sur3">

	<?php echo do_shortcode( '[su_button url="/enfance-jeunesse/paiement-en-ligne/" background="#009FE3" size="7"  wide="yes" radius="0" icon="icon: credit-card" class="hover105"]Paiements[/su_button]' );
		?>

        <?php echo do_shortcode( '[su_button url="mairie/demarches/" background="#009FE3" size="7" wide="yes" radius="0" icon="icon: pencil-square-o" class="hover105"]Vos démarches[/su_button]' );
		?>

        <?php echo do_shortcode( '[su_button url="http://commune-taule.keleseth.wdmedia.net/mairie/" background="#009FE3" size="7" wide="yes" radius="0" icon="icon: envelope-o" class="hover105"]Contact mairie[/su_button]' );
		?>

        <?php echo do_shortcode( '[tribe_mini_calendar]' );
		?>
        <div class="encadre-mairie">        
            <h2>Taulé Infos</h2>
            <p>Pour recevoir chaque mois le Taulé Infos par mail, entrez votre adresse mail</p>
            <?php echo do_shortcode( '[contact-form-7 id="758" title="Sans titre"]' );
		?>
        </div> <!--Ferme encadré mairie 1-->
 
        
        
        <div class="encadre-mairie">
          <?php
          //Appel du custom post infos Magazine
          $id = 745;
          $magazine = get_post($id);
          $title = $magazine->post_title;
          $contenu = $magazine->post_content;
          $contenu = apply_filters('the_content', $contenu);
          $contenu = str_replace(']]>', ']]&gt;', $contenu);
          ?>
          <?php echo "<h2>$title</h2>$contenu"; ?>
        </div> <!-- ferme encadre-mairie -->


    </div> <!-- ferme colonne3sur3 -->

	<div style="clear: both;"></div>	


	<footer class="entry-footer">
	</footer><!-- .entry-footer -->
</article><!-- #post-## -->
