<?php
/**
 * Template part for displaying posts
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package pierre17
 */

?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

	<div class="entry-content colonne-gauche-accueil">
				<?php
			the_content( sprintf(
				/* translators: %s: Name of current post. */
				wp_kses( __( 'Continue reading %s <span class="meta-nav">&rarr;</span>', 'pierre17' ), array( 'span' => array( 'class' => array() ) ) ),
				the_title( '<span class="screen-reader-text">"', '"</span>', false )
			) );

			wp_link_pages( array(
				'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'pierre17' ),
				'after'  => '</div>',
			) );
		?>
	</div><!-- .entry-content -->
	
	<div class="colonne2sur3">
	    <?php the_field('colonne2sur3'); ?>
	</div> <!-- ferme colonne-droite -->
	<div class="colonne3sur3">
	    <?php the_field('colonne3sur3'); ?>
	</div> <!-- ferme colonne-droite -->
	<div style="clear: both;"></div>	


	<footer class="entry-footer">
	</footer><!-- .entry-footer -->
</article><!-- #post-## -->
