<?php
/**
 * The main template file
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package taule-underscores
 */

get_header(); ?>



	<div id="primary" class="content-area">
	
	<div class="colonne-gauche">
		<main id="main" class="site-main" role="main">

		<?php
		if ( have_posts() ) :

			if ( is_home() && ! is_front_page() ) : ?>
				<header>
					<h1 class="page-title screen-reader-text"><?php single_post_title(); ?></h1>
				</header>

			<?php
			endif;

			/* Start the Loop */
			while ( have_posts() ) : the_post();

				/*
				 * Include the Post-Format-specific template for the content.
				 * If you want to override this in a child theme, then include a file
				 * called content-___.php (where ___ is the Post Format name) and that will be used instead.
				 */
				get_template_part( 'template-parts/content', get_post_format() );

			endwhile;

			the_posts_navigation();

		else :

			get_template_part( 'template-parts/content', 'none' );

		endif; ?>

		</main><!-- #main -->
		</div> <!-- ferme colonne-gauche -->
		<div class="colonne-droite">
		            <div class="encadre-mairie">        
            <h2>Taulé Infos</h2>
            <p>Pour recevoir chaque mois le Taulé Infos par mail, entrez votre adresse mail</p>
            <?php echo do_shortcode( '[contact-form-7 id="758" title="Sans titre"]' );
		?>
        </div> <!--Ferme encadré mairie 1-->
 
        
        
        <div class="encadre-mairie">
          <?php
          //Appel du custom post infos Magazine
          $id = 745;
          $magazine = get_post($id);
          $title = $magazine->post_title;
          $contenu = $magazine->post_content;
          $contenu = apply_filters('the_content', $contenu);
          $contenu = str_replace(']]>', ']]&gt;', $contenu);
          ?>
          <?php echo "<h2>$title</h2>$contenu"; ?>
        </div> <!-- ferme encadre-mairie -->
		</div> <!-- ferme colonne-droite -->
	</div><!-- #primary -->

<?php
get_sidebar();
get_footer();
