<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package pierre17
 */

?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>">
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="profile" href="http://gmpg.org/xfn/11">
<link href="https://fonts.googleapis.com/css?family=Open+Sans:400,400i,700,700i" rel="stylesheet"> 

<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<div id="page" class="site">
<a class="skip-link screen-reader-text" href="#content"><?php esc_html_e( 'Skip to content', 'pierre17' ); ?></a>

    <header id="masthead" class="site-header" role="banner">
        
        <div class="site-branding">
	<a id="logo" href="http://commune-taule.keleseth.wdmedia.net/"><img src="http://commune-taule.keleseth.wdmedia.net/wp-content/uploads/design/taule-logo-2.png" alt=""></a>
        </div><!-- .site-branding -->

	<nav id="site-navigation" class="main-navigation" role="navigation">

			<?php wp_nav_menu( array( 'theme_location' => 'menu-1', 'menu_id' => 'primary-menu' ) ); ?>
	</nav><!-- #site-navigation -->
    </header><!-- #masthead -->
	
<?php
if ( is_front_page() ) {
	    echo'<div id="slider">';
		echo do_shortcode( '[su_slider source="category: 12" limit="5" link="post" width="1600" height="580" mousewheel="no" autoplay="7000" speed="800" class="slider-accueil"]' );
        echo'</div> <!--ferme slider-->';
}
 ?>
	

	<div id="content" class="site-content">
<input type="button" id="bouton_hautdepage" value="Haut de page" OnClick="window.location.href='#logo'">
