// @codekit-append  "tag-name.js"
// @codekit-append  "icon.js"
// @codekit-append  "attributes.js"
// @codekit-append  "code.js"
// @codekit-append  "custom-css.js"

var ShortcodesUltimateMakerEditor = {};

ShortcodesUltimateMakerEditor.App = ( function( $ ) {

	/**
	 * Define main object.
	 */
	var self = {};

	/**
	 * Define component elements.
	 */
	self.el = {
		editor: $( '#shortcodes-ultimate-maker-editor' ),
		publishBtn: $( 'input#publish[name="publish"]' ),
		updateBtn: $( 'input#publish[name="save"]' )
	};

	/**
	 * Retrieve l10n strings.
	 */
	self.l10n = ShortcodesUltimateMakerEditorData.l10n.Editor;

	/**
	 * Initialize the editor and all of it's sub-modules.
	 */
	self.init = function() {

		// self.removePostboxClass();
		self.changePublishLabels();

		ShortcodesUltimateMakerEditor.TagName.init();
		ShortcodesUltimateMakerEditor.Icon.init();
		ShortcodesUltimateMakerEditor.Attributes.init();
		ShortcodesUltimateMakerEditor.Code.init();
		ShortcodesUltimateMakerEditor.CustomCss.init();

	};

	/**
	 * Remove 'postbox' class to make metabox look 'seamless'.
	 *
	 * @since  1.5.5
	 */
	self.removePostboxClass = function() {
		self.el.editor.removeClass( 'postbox' );
	};

	/**
	 * Change Publish/Update button labels.
	 */
	self.changePublishLabels = function() {

		self.el.publishBtn.val( self.l10n.createShortcode );
		self.el.updateBtn.val( self.l10n.updateShortcode );

	};

	return {
		init: self.init
	};

} )( jQuery );

jQuery( document ).ready( ShortcodesUltimateMakerEditor.App.init );