<?php
/*
Template Name: Acteurs
*/

get_header();

?>

	<main id="primary" class="site-main">


			<header class="page-header">
			<h1>
				<?php 
				the_title(); 
				?>
			</h1>
			</header><!-- .page-header -->

<?php	
// 1. on définit ce que l'on veut

$paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;    

$args = array(
    'posts_per_page' => 4,
	'paged' => $paged,
	'post_type' => 'acteurs'
	);

// 2. on exécute la query
$my_query = new WP_Query($args);

// 3. on lance la boucle !
if($my_query->have_posts()) : while ($my_query->have_posts() ) : $my_query->the_post();
    
    ?>
    <div class="photo-acteurs">
    <?php
        the_post_thumbnail();
    ?>
    </div> <!-- fin .photo-acteurs -->
    <div class="contenu-acteurs">
    <?php
 
    the_title( '<h2 class="nom-acteurs">', '</h2>' );
    
    the_content();
    ?>
    </div> <!--Fin .contenu-acteurs -->
    <div style="clear:both"></div>
    <?php
    
endwhile;


?>
<nav class="pagination">
<?php


$prev_arrow = is_rtl() ? '<span class="arrow-right"></span><span class="direction-text">&raquo;</span>
' : '<span class="arrow-left"></span><span class="direction-text">&laquo;</span>
';
$next_arrow = is_rtl() ? '<span class="arrow-left"></span><span class="direction-text">&laquo;</span>
' : '<span class="arrow-right"></span><span class="direction-text">&raquo;</span>
';
$total = $my_query->max_num_pages;
$big = 999999999; // need an unlikely integer
if( $total > 1 ) {
  if( !$current_page = get_query_var('paged') )
    $current_page = 1;
    if( get_option('permalink_structure') ) {
      $format = 'page/%#%/';
    } else {
      $format = '&paged=%#%';
    }
echo paginate_links(array(
  'base' => str_replace( $big, '%#%', esc_url( get_pagenum_link( $big ) ) ),
  'format' => $format,
  'current' => max( 1, get_query_var('paged') ),
  'total' => $total,
  'mid_size' => 3,
  'type' => 'list',
  'prev_text' => $prev_arrow,
  'next_text' => $next_arrow,
));
}

?>
</nav><!-- fin pagination-->
<?php



endif;


// 4. On réinitialise à la requête principale (important)
wp_reset_postdata();	



?>



	
	</main><!-- #primary .main -->

<?php
get_footer();
