<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package aaa
 */

?>
<!doctype html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="https://gmpg.org/xfn/11">
	
<link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<link href="https://fonts.googleapis.com/css2?family=Montserrat:ital,wght@0,300;0,400;0,600;1,300;1,400;1,600&display=swap" rel="stylesheet"> 

	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<?php wp_body_open(); ?>
<div id="page" class="site">
	<a class="skip-link screen-reader-text" href="#primary"><?php esc_html_e( 'Skip to content', 'aaa' ); ?></a>

	<header id="masthead" class="site-header">		
		
	    <div class="site-branding">
            <a href="/"><img src="<?php echo get_stylesheet_directory_uri(); ?>/design/reseau-professionnels-patrimoine-breton-logo.svg" alt="Logo du Réseau des professionnels du patrimoine en Bretagne" onerror="this.removeAttribute('onerror'); this.src='<?php echo get_stylesheet_directory_uri(); ?>/design/reseau-professionnels-patrimoine-breton-logo.png'"/></a>

		</div><!-- .site-branding -->
		
		
		<nav id="menu-en-tete" class="menu-general">
            <input type="checkbox" class="menu-checkbox" id="menu-checkbox" />
			<label for="menu-checkbox" class="menu-toggle">&equiv; Menu</label>
			
			<?php
			wp_nav_menu(
				array(
					'container' => 'false',
					'theme_location' => 'menu-1',
					'menu_id'        => 'ul-menu-en-tete',

				)
			);
			?>
		</nav><!-- #site-navigation -->
		
		
		
		<nav class="boutons">
			
			<a href="https://www.facebook.com/reseau.patrimoine.bzh"><img src="<?php echo get_stylesheet_directory_uri(); ?>/design/picto-facebook.svg" alt="Facebook" onerror="this.removeAttribute('onerror'); this.src='<?php echo get_stylesheet_directory_uri(); ?>/design/picto-facebook.png'"/></a>
			<a href="https://www.facebook.com/violaine.vart"><img src="<?php echo get_stylesheet_directory_uri(); ?>/design/picto-instagram.svg" alt="Instagram" onerror="this.removeAttribute('onerror'); this.src='<?php echo get_stylesheet_directory_uri(); ?>/design/picto-instagram.png'"/></a>
			<a href="https://www.facebook.com/violaine.vart"><img src="<?php echo get_stylesheet_directory_uri(); ?>/design/picto-contact.svg" alt="contact" onerror="this.removeAttribute('onerror'); this.src='<?php echo get_stylesheet_directory_uri(); ?>/design/picto-contact.png'"/></a>

		</nav><!-- .boutons -->


	</header><!-- #masthead -->
	<div id='image-en-tete' class='alignfull'>
		<img src="<?php echo get_stylesheet_directory_uri(); ?>/design/reseau-professionnels-patrimoine-bretagne.webp" alt="" />	
		<div id="glyphe-orange">
		<img src="<?php echo get_stylesheet_directory_uri(); ?>/design/glyphe-patrimoine-orange.svg" alt="contact" onerror="this.removeAttribute('onerror'); this.src='<?php echo get_stylesheet_directory_uri(); ?>/design/glyphe-patrimoine-orange.png'"/>
	     </div> <!-- #glyphe-orange -->
	</div> <!-- #image-en-tete -->

