<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package plougasnou
 */

?>
<!doctype html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="https://gmpg.org/xfn/11">

	<?php wp_head(); ?>
	 <link rel="preconnect" href="https://fonts.gstatic.com">
     <link href="https://fonts.googleapis.com/css2?family=Source+Sans+Pro:ital,wght@0,400;0,700;1,400;1,700&display=swap" rel="stylesheet"> 
	
	
	<!-- Google tag (gtag.js) -->
<script async src="https://www.googletagmanager.com/gtag/js?id=G-MJKZ1R3QQT"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());

  gtag('config', 'G-MJKZ1R3QQT');
</script>
	
	
	
</head>

<body <?php body_class(); ?>>
<?php wp_body_open(); ?>
<div id="page" class="site">
	<a class="skip-link screen-reader-text" href="#primary"><?php esc_html_e( 'Skip to content', 'plougasnou' ); ?></a>

	<header id="masthead" class="site-header">
		<div class="site-branding">
          <a href="/accueil"><img src="<?php echo get_stylesheet_directory_uri(); ?>/img/plougasnou-medaille.svg" alt="Commune de Plougasnou" onerror="this.removeAttribute('onerror'); this.src=<?php echo get_stylesheet_directory_uri(); ?>/img/plougasnou-medaille.png'"/></a>
		</div><!-- .site-branding -->
		


		<form id="recherche-header" action="<?= esc_url(home_url('/')) ?>">
    <input class="formulaire-recherche" name="s" type="search" placeholder="Recherche" aria-label="Search" value="<?= get_search_query() ?>">
    <button class="bouton-recherche" type="submit"></button>
        </form>
		
		<nav id="vousetes">
			<span>Vous êtes &gt;&gt;&gt;</span>
			<ul>
				<li class="bouton-asso"><a href="<?php echo get_permalink(640); ?>">Association</a></li>
				<li class="bouton-entrepreneur"><a href="<?php echo get_permalink(613); ?>">Entrepreneur</a></li>
				<li class="bouton-senior"><a href="<?php echo get_permalink(692); ?>">Senior</a></li>
				<li class="bouton-famille"><a href="<?php echo get_permalink(702); ?>">Famille</a></li>
			</ul>
		</nav>
				
        <div style="clear:both;"></div>
		
		
		<nav id="site-navigation" class="main-navigation">
			
			
			<input type="checkbox" class="menu-checkbox" id="menu-checkbox" />
			<label for="menu-checkbox" class="menu-toggle">&equiv; Menu</label>
			
			
			
			<?php
			wp_nav_menu(
				array(
					'container' => 'false',
					'theme_location' => 'menu-1',
					'menu_id'        => 'primary-menu',
				)
			);
			?>
		
		</nav><!-- #site-navigation -->
		
		<div id="menu-pictos">
			<a href="https://www.plougasnou.fr/contact/"><img src="<?php echo get_stylesheet_directory_uri(); ?>/img/picto-contact.svg" alt="Contact" onerror="this.removeAttribute('onerror'); this.src='<?php echo get_stylesheet_directory_uri(); ?>img/picto-contact.png'"/></a>
			<a href="https://www.facebook.com/mairiedeplougasnou"><img src="<?php echo get_stylesheet_directory_uri(); ?>/img/picto-facebook.svg" alt="Facebook" onerror="this.removeAttribute('onerror'); this.src='<?php echo get_stylesheet_directory_uri(); ?>img/picto-facebook.png'"/></a>
		</div>

	</header><!-- #masthead -->
