<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package plougasnou
 */

?>
    <div id="bandeau-bas">
	    <footer id="colophon" class="site-footer pleine-largeur">
		
            <div id="adresse">
			  <p><a href="mailto:contact@plougasnou.fr"><img src="<?php echo get_stylesheet_directory_uri(); ?>/img/picto-mail-blanc.svg" alt="Commune de Plougasnou" onerror="this.removeAttribute('onerror'); this.src=<?php echo get_stylesheet_directory_uri(); ?>/img/picto-mail-blanc.png'"/>contacter la mairie par mail</a></p>
			  <p><strong>Mairie de Plougasnou</strong><br>14 rue François Charles</p>
				
				<p>
				La mairie est ouverte du lundi au vendredi 
				<br>de 9h00 à 12h00 et de 13h30 à 17h30
				<br>Fermée au public le jeudi après-midi
				<br>Service urbanisme fermé au public le jeudi					
				</p>
				
			
			  <p><img src="<?php echo get_stylesheet_directory_uri(); ?>/img/picto-telephone-blanc.svg" alt="Commune de Plougasnou" onerror="this.removeAttribute('onerror'); this.src=<?php echo get_stylesheet_directory_uri(); ?>/img/picto-telephone-blanc.png'"/><a href="tel:+33298673006">02 98 67 30 06</a></p>
		    </div><!-- #adresse -->
		
		    <div id="reseaux-sociaux">
			  <div><a href="https://www.facebook.com/mairiedeplougasnou"><img src="<?php echo get_stylesheet_directory_uri(); ?>/img/picto-facebook-blanc.svg" alt="Facebook" onerror="this.removeAttribute('onerror'); this.src=<?php echo get_stylesheet_directory_uri(); ?>/img/picto-facebook-blanc.png'"/></a></div>					
			  <div><p><strong>Suivre les actualités<br>de la mairie sur facebook</strong></p></div>
			  <p>&nbsp;</p>
			  <div><a href="https://app.gwig.fr/commune/plougasnou"><img src="<?php echo get_stylesheet_directory_uri(); ?>/img/picto-gwig.svg" width="32" height="32" alt="Gwig"></a></div>
			  <div><p><strong>Suivre les actualités<br>de la mairie sur gwig</strong></p></div>
			  <p>&nbsp;</p>	
				
			  <p class="signature"><a href="https://www.plougasnou.fr/politique-de-confidentialite/">Politique de confidentialité<br>et mentions légales</a></p>
			
		    </div><!-- #reseaux-sociaux -->
		    <div id="rechercheetsignature">
		      <form id="recherche-footer" action="<?= esc_url(home_url('/')) ?>">
              <input class="formulaire-recherche" name="s" type="search" placeholder="Recherche" aria-label="Search" value="<?= get_search_query() ?>">
              <button class="bouton-recherche" type="submit"></button>
              </form>
			  <p>&nbsp;</p><p>&nbsp;</p>
			  <p class="signature">
				Réalisation <a href="https://violaine-pierret.com/">Agence Violaine Pierret</a>
			  </p>
		    </div><!--rechercheetsignature-->
				
		
	</footer><!-- #colophon -->
    </div>	<!-- #bandeau-bas-->

</div><!-- #page -->

<?php
if ( is_front_page() ) { ?>
	<script type="text/javascript" src="<?php echo bloginfo('template_directory'); ?>/js/jquery-1.7.1.min.js"></script>
<script type="text/javascript" src="<?php echo bloginfo('template_directory'); ?>/js/AnimationSliderActu.js"></script>
<?php } ?>

<?php wp_footer(); ?>

</body>
</html>
