<?php


add_action( 'wp_enqueue_scripts', 'theme_enqueue_styles' );
function theme_enqueue_styles() {
    wp_enqueue_style( 'parent-style', get_template_directory_uri() . '/style.css' );

}

/**
 * Registers our main widget area and the front page widget areas.
 *
 * @since Twenty Twelve 1.0
 */
 
 
/** AJOUT DES FOURCHETTES : direct dans le thème de base
function twentytwelve_widgets_init() {
	register_sidebar( array(
		'name' => __( 'Main Sidebar', 'twentytwelve' ),
		'id' => 'sidebar-1',
		'description' => __( 'Appears on posts and pages except the optional Front Page template, which has its own widgets', 'twentytwelve' ),
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget' => '</aside>',
		'before_title' => '<img src="https://www.cuisinons-les-legumes.com/wp-content/uploads/fourchette-cuisinons-les-legumes.jpg" alt="Cuisinons les légumes"><h3 class="widget-title">',
		'after_title' => '</h3>',
	) );

	register_sidebar( array(
		'name' => __( 'First Front Page Widget Area', 'twentytwelve' ),
		'id' => 'sidebar-2',
		'description' => __( 'Appears when using the optional Front Page template with a page set as Static Front Page', 'twentytwelve' ),
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget' => '</aside>',
		'before_title' => '<img src="https://www.cuisinons-les-legumes.com/wp-content/uploads/fourchette-cuisinons-les-legumes.jpg" alt="Cuisinons les légumes"><h3 class="widget-title">',
		'after_title' => '</h3>',
	) );

	register_sidebar( array(
		'name' => __( 'Second Front Page Widget Area', 'twentytwelve' ),
		'id' => 'sidebar-3',
		'description' => __( 'Appears when using the optional Front Page template with a page set as Static Front Page', 'twentytwelve' ),
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget' => '</aside>',
		'before_title' => '<img src="https://www.cuisinons-les-legumes.com/wp-content/uploads/fourchette-cuisinons-les-legumes.jpg" alt="Cuisinons les légumes"><h3 class="widget-title">',
		'after_title' => '</h3>',
	) );
}
add_action( 'widgets_init', 'twentytwelve_widgets_init' );
 */
/**
Ajout Pierre decembre 2014
pour avoir des nombres d'articles affichés différents suivant les situations
 */

add_filter( 'pre_get_posts', 'quantity_per_view' );
function quantity_per_view( $wp_query = '' ) {
	if ( is_search() ) { // recherche
		$wp_query->query_vars['posts_per_page'] = 36;
	} elseif ( is_category() ) { // Category
		$wp_query->query_vars['posts_per_page'] = 28;
	} elseif ( is_tag() ) { // Tag
		$wp_query->query_vars['posts_per_page'] = 36;
	} elseif ( is_author() ) { // Auteur
		$wp_query->query_vars['posts_per_page'] = 10;
	} elseif ( is_date() ) { // Archive
		$wp_query->query_vars['posts_per_page'] = 10;
	}

	return $wp_query;
}

// Ajout Pierre decembre 2014 enlever les nofollow des liens dans les commentaires et sur l'auteur
function comment_remove_nofollow($str) {
    $str = preg_replace("/(<a[^>]*[^\s])(\s*nofollow\s*)/i", "$1", $str);
    $str = preg_replace("/(<a[^>]*[^\s])(\s*rel=[\"\']\s*[\"\'])/i", "$1", $str);
    return $str;
}
add_filter('get_comment_author_link', 'comment_remove_nofollow');
add_filter('comment_text', 'comment_remove_nofollow');


//Ajout Pierre fev 2016 pour coller le menu au haut de page
	    function menufixed_js(){
     wp_register_script("menufixed", get_stylesheet_directory_uri()."/js/menufixed.js", array("jquery"), true);
     wp_enqueue_script("menufixed");
    }

    add_action("wp_footer", "menufixed_js"); 

