<?php
/**
 * @package themify
 * @since 1.1.1.0
 * 
 * ----------------------------------------------------------------------
 * 					DO NOT EDIT THIS FILE
 * ----------------------------------------------------------------------
 * 				Class to interact with TinyMCE editor. 
 *  			http://themify.me
 *  			Copyright (C) Themify
 *
 ***************************************************************************/

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Themify_TinyMCE {
	
	function __construct(){
		if ( current_user_can( 'publish_posts' ) && get_user_option( 'rich_editing' ) == 'true' ) {
			add_filter( 'mce_external_plugins', array( $this, 'add_plugin' ) );
			add_filter( 'mce_buttons', array( $this, 'add_button' ) );
			add_action( 'wp_enqueue_scripts', array( $this, 'localize' ) );
			add_action( 'admin_enqueue_scripts', array( $this, 'localize' ) );
		}
	}

	/**
	 * Add button to WP Editor.
	 *
	 * @param array $mce_buttons
	 * @return mixed
	 */
	function add_button( $mce_buttons ) {
		array_push( $mce_buttons, 'separator', 'btnthemifyMenu' );
		return $mce_buttons;
	}

	/**
	 * Add plugin JS file to list of external plugins.
	 *
	 * @param array $mce_external_plugins
	 * @return mixed
	 */
	function add_plugin( $mce_external_plugins ) {
		global $wp_version;
		if ( version_compare( $wp_version, '3.9', '>=' ) ) {
			$mce_external_plugins['themifyMenu'] = THEMIFY_URI . '/tinymce/plugin.js';
		} else {
			$mce_external_plugins['themifyMenu'] = THEMIFY_URI . '/tinymce/tinymce.menu.js';
		}
		return $mce_external_plugins;
	}

	/**
	 * Pass strings to JS to set the labels of the WP Editor shortcode button and menu.
	 *
	 * @since 1.8.9
	 */
	function localize() {
		wp_localize_script( 'editor', 'themifyEditor', array(
			'nonce' => wp_create_nonce( 'themify-editor-nonce' ),
			'editor' => array(
				'menuTooltip' => __('Shortcodes', 'themify'),
				'menuName' => __('Shortcodes', 'themify'),
				'button' => __('Button', 'themify'),
				'columns' => __('Columns', 'themify'),
				'half21' => __('2-1 Half', 'themify'),
				'half21first' => __('2-1 Half First', 'themify'),
				'third31' => __('3-1 One-Third', 'themify'),
				'third31first' => __('3-1 One-Third First', 'themify'),
				'quarter41' => __('4-1 Quarter', 'themify'),
				'quarter41first' => __('4-1 Quarter First', 'themify'),
				'image' => __('Image', 'themify'),
				'horizontalRule' => __('Horizontal Rule', 'themify'),
				'quote' => __('Quote', 'themify'),
				'isLoggedIn' => __('Is Logged In', 'themify'),
				'isGuest' => __('Is Guest', 'themify'),
				'map' => __('Map', 'themify'),
				'video' => __('Video', 'themify'),
				'flickr' => __('Flickr Gallery', 'themify'),
				'twitter' => __('Twitter Stream', 'themify'),
				'postSlider' => __('Post Slider', 'themify'),
				'customSlider' => __('Custom Slider', 'themify'),
				'slider' => __('Slider', 'themify'),
				'slide' => __('Slide', 'themify'),
				'listPosts' => __('List Posts', 'themify'),
				'box' => __('Box', 'themify'),
				'authorBox' => __('Author Box', 'themify'),
				'icon' => __('Icon', 'themify'),
			)
		));
	}
}

/**
 * Initialize class to add button to WP Editor.
 */
function themify_init_tinymce() {
	new Themify_TinyMCE();
}
add_action( 'init', 'themify_init_tinymce' );