<?php
/***************************************************************************
 *
 * 	----------------------------------------------------------------------
 * 						DO NOT EDIT THIS FILE
 *	----------------------------------------------------------------------
 * 
 *  				     Copyright (C) Themify
 * 
 *	----------------------------------------------------------------------
 *
 ***************************************************************************/

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/* 	Database Functions
/***************************************************************************/

// Store Cached Data
$themify_data = array();
$themify_cached = false;

/**
 * Save Data
 * @param Array $data
 * @return String
 * @since 1.0.0
 * @package themify
 */
function themify_set_data( $data ) {
	global $themify_data, $themify_cached;
	if ( empty( $data ) || ! is_array( $data ) ) {
		$data = array();
	}
	foreach ( $data as $name => $value ) {
		if ( 'save' == $name || 'page' == $name ) {
			unset( $data[$name] );
		}
	}
	update_option( 'themify_data', $data);
	$themify_data = themify_sanitize_data( $data );
	$themify_cached = false;
	return $themify_data; // MUST return $themify_data since it's the sanitized value
}

/**
 * Return cached data
 * @return array|String
 */
function themify_get_data() {
	global $themify_data, $themify_cached;
	if ( !$themify_cached ) {
		$themify_data = get_option( 'themify_data' );
		$themify_data = themify_sanitize_data( $themify_data );
		$themify_cached = true;
	}
	return $themify_data;
}

/**
 * Abstract away normalizing the data
 * @param $data
 * @return array
 */
function themify_sanitize_data( $data ) {
	if ( is_array( $data ) && count( $data ) >= 1 ) {
		foreach( $data as $name => $value ){
			if ( in_array( $name, array( 'setting-custom_css', 'setting-header_html', 'setting-footer_html', 'setting-footer_text_left', 'setting-footer_text_right', 'setting-homepage_welcome', 'setting-store_info_address' ) )
				|| ( false !== stripos( $name, 'setting-hooks' ) )
			) {
				$data[$name] = str_replace( "\'", "'", $value );
			} else {
				$data[$name] = stripslashes( $value );
			}
		}
		return $data;
	}
	return array();
}