/***************************************************************************
 *
 * 	----------------------------------------------------------------------
 * 						DO NOT EDIT THIS FILE
 *	----------------------------------------------------------------------
 *                      Theme Customizer Scripts
 *  				    Copyright (C) Themify
 *
 *	----------------------------------------------------------------------
 *
 ***************************************************************************/
(function( exports, $ ){

	'use strict';

	var api = wp.customize,
		customCSSInit = true;

	window.onbeforeunload = function() {
		if ( ! wp.customize.state('saved')() ) {
			return themifyCustomizerControls.confirm_on_unload;
		}
	};

	$( window ).on( 'message', function(e){
		var msg = $.parseJSON( e.originalEvent.data );
		if ( 'synced' == msg.id && 'preview-0' == msg.channel ) {
			// Starting in WP 4.1, place controls inside accordions
			setTimeout(function(){
				$('.themify-subaccordion').each(function() {
					var $self = $(this),
						thisGroup = $self.data('accordion');
					$('.' + thisGroup + '-group').appendTo($self);
				});

				// Nest main nav menus
				$('li[id*=nav_menu_locations]').each(function() {
					var $self = $(this);
					$self.appendTo($self.prev().find('.themify-subaccordion'));
				});

				// Open Themify Options on page load
				$('#accordion-section-themify_options').find('.accordion-section-title').trigger('click');

				// Trigger Custom CSS initially to apply its settings
				var $customCSS = $('#customize-control-customcss_ctrl').find('.customcss');
				if ( $customCSS.length > 0 ) {
					$customCSS.each(function(){
						var $self = $(this);
						if ( '' != $self.val() ) {
							$self.trigger('keyup');
							api.trigger( 'saved' );
						}
					});
				}
			}, 100);
		}
	} );

	////////////////////////////////////////////////////////////////////////////
	// Accordion Start
	////////////////////////////////////////////////////////////////////////////
	api.ThemifySubAccordion = api.Control.extend({
		ready: function() {
			var control = this,
				$a = $('.themify-suba-toggle', control.container ),
				$ul = $a.next();

			$('.customize-control.customize-control-themify_subaccordion_end').remove();

			$a.on('click', function(e){
				e.preventDefault();
				$(this).parent().toggleClass('topen');
				$ul.toggleClass('tpanelopen');
			});

			var $navMenu = $('select[data-customize-setting-link^=nav_menu_locations]', control.container);
			$navMenu.closest('label').map(function() {
				$(this).replaceWith( $(this).contents() );
			});
			$navMenu.wrap('<div class="themify-customizer-brick" />').wrap('<div class="custom-select nav-menu-select" />');
		}
	});
	api.controlConstructor.themify_subaccordion_start = api.ThemifySubAccordion;
	////////////////////////////////////////////////////////////////////////////
	// Accordion End
	////////////////////////////////////////////////////////////////////////////

	/***************************************************************************
	 *                      ThemifyControl Start
	 *
	 * This Model serves as a foundation to derive the other controls.
	 * When initializing an inherited Model, the ready() method must be defined.
	 ***************************************************************************/
	api.ThemifyControl = api.Control.extend({

		value: {},

		/**
		 * This property must be defined in inherited models.
		 * Must be set to the class of the hidden text field that stores the settings.
		 * Example: .themify_background_control
		 */
		field: '',

		openMedia: function() {
			var control = this,	$field = $(control.field, control.container),
				file_frame = '';

			$('.open-media', control.container).on('click', function(e){
				e.preventDefault();

				file_frame = wp.media.frames.file_frame = wp.media({
					title: $(this).data('uploader-title'),
					library: {
						type: ['image']
					},
					button: {
						text: $(this).data('uploader-button-text')
					},
					multiple: false
				});

				file_frame.on( 'select', function() {
					var attachment = file_frame.state().get('selection').first().toJSON();

					var $imgPreview = $('<a href="#" class="remove-image ti-close"></a><img src="' + attachment.url + '" />').css('display', 'inline-block');

					var $preview = $('.themify_control_preview', control.container),
						$close = $('a', $preview ),
						$imgPre = $('img', $preview);

					control.value[control.id].id = attachment.id;
					control.value[control.id].src = attachment.url;

					$field.val( JSON.stringify( control.value[control.id] ) ).trigger('change');

					if( $close.length > 0 ) {
						$close.remove();
					}
					if( $imgPre.length > 0 ) {
						$imgPre.remove();
					}

					$preview.append( $imgPreview ).fadeIn();
				});

				file_frame.open();
			});

			// Remove image
			$('.open-media-wrap', control.container).on('click', '.remove-image', function(e){
				e.preventDefault();
				control.value[control.id].id = '';
				control.value[control.id].src = '';
				$field.val( JSON.stringify( control.value[control.id] ) ).trigger('change');
				$(this).next().remove();
				$(this).remove();
			});
		},

		pickColor: function() {
			var control = this,	$field = $(control.field, control.container),
				$color = $('.color-select', control.container),
				$removeColor = $('.remove-color', control.container);

			// Color Picker
			$color.minicolors( {
				defaultValue: '',
				letterCase: 'lowercase',
				opacity: true,
				change: function(hex, opacity) {
					control.value[control.id].color = hex.replace( '#', '' );
					control.value[control.id].opacity = opacity;
					$field.val( JSON.stringify( control.value[control.id] ) ).trigger('change');
					$removeColor.show();
				},
				hide: function() {
					if ( '' != $(this).val() ) {
						control.value[control.id].color = $(this).val().replace( '#', '' );
						$field.val( JSON.stringify( control.value[control.id] ) ).trigger('change');
						$removeColor.show();
					}
				}
			});
			// Clear color field
			$removeColor.on( 'click', function(e){
				e.preventDefault();
				control.value[control.id].color = '';
				control.value[control.id].opacity = '';
				$field.val( JSON.stringify( control.value[control.id] ) ).trigger('change');
				$color.minicolors( 'value', '' );
				$color.minicolors( 'opacity', '' );
				$removeColor.hide();
			});
		},

		pickBorderColor: function() {
			var control = this,	$field = $(control.field, control.container ),
				$color = $('.color-select', control.container),
				$removeColor = $('.remove-color', control.container ),
				$same = $('.same', control.container);

			// Color Picker
			$color.minicolors( {
				defaultValue: '',
				letterCase: 'lowercase',
				opacity: true,
				change: function(hex, opacity) {
					var side = $(this).data('side'),
						color = hex.replace( '#', '' );
					if ( $same.prop('checked') ) {
						control.value[control.id].color = color;
						control.value[control.id].opacity = opacity;
						control.value[control.id].same = 'same';
					} else {
						control.value[control.id][side] = _.extend({}, control.value[control.id][side], {
							'color' : color,
							'opacity' : opacity
						});
						if ( 'top' == side ) {
							control.value[control.id].color = color;
							control.value[control.id].opacity = opacity;
						}
						control.value[control.id].same = '';
					}
					$field.val( JSON.stringify( control.value[control.id] ) ).trigger('change');
					$(this).parent().next().show();
				},
				hide: function() {
					if ( '' != $(this).val() ) {
						var hex = $(this).val(),
							side = $(this).data('side'),
							color = hex.replace( '#', '' );
						if ( $same.prop('checked') ) {
							control.value[control.id].color = color;
							control.value[control.id].same = 'same';
						} else {
							control.value[control.id][side] = _.extend({}, control.value[control.id][side], {
								'color' : color
							});
							if ( 'top' == side ) {
								control.value[control.id].color = color;
							}
							control.value[control.id].same = '';
						}
						$field.val( JSON.stringify( control.value[control.id] ) ).trigger('change');
						$(this).parent().next().show();
					}
				}
			});
			// Clear color field
			$removeColor.on( 'click', function(e){
				e.preventDefault();
				var side = $(this).data('side');

				if ( $same.prop('checked') ) {
					control.value[control.id].color = '';
					control.value[control.id].opacity = '';
					control.value[control.id].same = 'same';
				} else {
					control.value[control.id][side] = _.extend({}, control.value[control.id][side], {
						'color' : '',
						'opacity' : ''
					});
					if ( 'top' == side ) {
						control.value[control.id].color = '';
						control.value[control.id].opacity = '';
					}
					control.value[control.id].same = '';
				}
				$field.val( JSON.stringify( control.value[control.id] ) ).trigger('change');
				var $color = $(this).siblings('.minicolors').children('.color-select');
				$color.minicolors( 'value', '' );
				$color.minicolors( 'opacity', '' );
				$(this).hide();
			});
		},

		transparent: function($obj) {
			var control = this,	$field = $(control.field, control.container );

			$obj.on('click', function(){
				var $self = $(this);
				if ( $self.prop('checked') ) {
					control.value[control.id].transparent = 'transparent';
					$self.parent().prev().addClass('transparent');
				} else {
					control.value[control.id].transparent = '';
					$self.parent().prev().removeClass('transparent');
				}
				$field.val( JSON.stringify( control.value[control.id] ) ).trigger('change');
			});
			if ( $obj.prop('checked') ) {
				$obj.parent().prev().addClass('transparent');
			}
		},

		dropdown: function($obj, key) {
			var control = this,	$field = $(control.field, control.container);

			$obj.on('change', function(){
				control.value[control.id][key] = $('option:selected', $(this)).val();
				$field.val( JSON.stringify( control.value[control.id] ) ).trigger('change');
			});
		},

		collapse: function($obj) {
			var control = this,	$field = $(control.field, control.container);

			$obj.on('click', function(){
				var $self = $(this);
				if ( $self.prop('checked') ) {
					control.value[control.id].disabled = 'disabled';
					$self.parent().siblings('.themify-customizer-brick').stop().slideUp();
				} else {
					control.value[control.id].disabled = '';
					var $same = $self.parent().parent().find('input[type=checkbox].same');
					if ( $same.length > 0 && $same.prop('checked') ) {
						$self.parent().siblings('.useforall, .collapse-same').stop().slideDown();
					} else {
						$self.parent().siblings('.themify-customizer-brick').stop().slideDown();
					}
				}
				$field.val( JSON.stringify( control.value[control.id] ) ).trigger('change');
			});
			if ( $obj.prop('checked') ) {
				$obj.parent().siblings('.themify-customizer-brick').hide();
			}
		},

		input: function($obj, key){
			var control = this,	$field = $(control.field, control.container);

			$obj.on('keyup', function(){
				control.value[control.id][key] = $(this).val();
				$field.val( JSON.stringify( control.value[control.id] ) ).trigger('change');
			});
		},

		dimension: function($obj){
			var control = this,	$field = $(control.field, control.container);

			$obj.on('keyup', function(){
				control.value[control.id].width = $(this).val();
				$field.val( JSON.stringify( control.value[control.id] ) ).trigger('change');
			});
		},

		dimensionSame: function($obj){
			var control = this,	$field = $(control.field, control.container),
				$same = $('.same', control.container);

			$obj.on('keyup', function(){
				var side = $(this).data('side'),
				    width = $(this).val();

				if ( $same.prop('checked') ) {
					control.value[control.id].width = width;
					control.value[control.id].same = 'same';
				} else {
					control.value[control.id][side] = _.extend({}, control.value[control.id][side], {
						'width' : width
					});
					if ( 'top' == side ) {
						control.value[control.id].width = width;
					}
					control.value[control.id].same = '';
				}
				$field.val( JSON.stringify( control.value[control.id] ) ).trigger('change');
			});
		},

		auto: function($obj) {
			var control = this,	$field = $(control.field, control.container),
				hide = $obj.data('hide');

			$obj.on('click', function(){
				var $self = $(this);
				if ( $self.prop('checked') ) {
					control.value[control.id].auto = 'auto';
					$(control.container).find('.'+hide).stop().addClass('hide-horizontally');
				} else {
					control.value[control.id].auto = '';
					$(control.container).find('.'+hide).stop().removeClass('hide-horizontally');
				}
				$field.val( JSON.stringify( control.value[control.id] ) ).trigger('change');
			});
			if ( $obj.prop('checked') ) {
				$(control.container).find('.'+hide).addClass('hide-horizontally');
			}
		},

		autoSame: function($obj) {
			var control = this,	$field = $(control.field, control.container),
				$same = $('.same', control.container);

			$obj.on('click', function(){
				var $self = $(this),
					hide = $self.data('hide' ),
					side = $(this).data('side' ),
					obj = {};

				if ( $same.prop('checked') ) {
					if ( $self.prop('checked') ) {
						obj.auto = 'auto';
						control.value[control.id].auto = 'auto';
						control.value[control.id].top = _.extend({}, control.value[control.id].top, obj);
						$(control.container).find('.'+hide).stop().addClass('hide-horizontally');
					} else {
						obj.auto = '';
						control.value[control.id].auto = '';
						control.value[control.id].top = _.extend({}, control.value[control.id].top, obj);
						$(control.container).find('.'+hide).stop().removeClass('hide-horizontally');
					}
					control.value[control.id].same = 'same';
				} else {
					if ( $self.prop('checked') ) {
						obj.auto = 'auto';
						control.value[control.id][side] = _.extend({}, control.value[control.id][side], obj);
						if ( 'top' == side ) {
							control.value[control.id].auto = 'auto';
						}
						$(control.container).find('.'+hide).stop().addClass('hide-horizontally');
					} else {
						obj.auto = '';
						control.value[control.id][side] = _.extend({}, control.value[control.id][side], obj);
						if ( 'top' == side ) {
							control.value[control.id].auto = '';
						}
						$(control.container).find('.'+hide).stop().removeClass('hide-horizontally');
					}
					control.value[control.id].same = '';
				}

				$field.val( JSON.stringify( control.value[control.id] ) ).trigger('change');
			});
			$obj.each(function(){
				var $self = $(this),
					hide = $self.data('hide');
				if ( $self.prop('checked') ) {
					$(control.container).find('.'+hide).addClass('hide-horizontally');
				}
			});
		},

		dropdownSame: function($obj, key){
			var control = this,	$field = $(control.field, control.container),
				$same = $('.same', control.container);

			$obj.on('change', function(){
				var side = $(this).data('side'),
				    val = $('option:selected', $(this)).val();
				if ( $same.prop('checked') ) {
					control.value[control.id][key] = val;
					control.value[control.id].same = 'same';
				} else {
					var obj = {}; obj[key] = val;
					control.value[control.id][side] = _.extend({}, control.value[control.id][side], obj);
					if ( 'top' == side ) {
						control.value[control.id][key] = val;
					}
					control.value[control.id].same = '';
				}
				$field.val( JSON.stringify( control.value[control.id] ) ).trigger('change');
			});
		},

		dropdownBorderSame: function($obj){
			var control = this,	$field = $(control.field, control.container ),
				$same = $('.same', control.container);

			$obj.on('change', function(){
				var $self = $(this),
					side = $self.data('side' ),
				    style = $('option:selected', $self).val();
				if ( $same.prop('checked') ) {
					control.value[control.id].style = style;
					control.value[control.id].same = 'same';
				} else {
					control.value[control.id][side] = _.extend({}, control.value[control.id][side], {
						'style' : style
					});
					if ( 'top' == side ) {
						control.value[control.id].style = style;
					}
					control.value[control.id].same = '';
				}
				$field.val( JSON.stringify( control.value[control.id] ) ).trigger('change');
				if ( 'none' == style ) {
					$self.parent().siblings('.color-picker, .border-width, .dimension-unit-label').hide();
				} else {
					$self.parent().siblings('.color-picker, .border-width, .dimension-unit-label').show();
				}
			});

			$obj.each(function(){
				var $self = $(this),
				    style = $('option:selected', $self).val();
				if ( 'none' == style ) {
					$self.parent().siblings('.color-picker, .border-width, .dimension-unit-label').hide();
				} else {
					$self.parent().siblings('.color-picker, .border-width, .dimension-unit-label').show();
				}
			});
		},

		hideComponentsSame: function($obj) {
			var control = this,	$field = $(control.field, control.container),
				$components = $('.component', control.container),
				$rowLabel = $('.dimension-row-label:not(.same-label)', control.container ),
				$sameLabel = $obj.parent().parent().find('.same-label');

			$obj.on('click', function(){
				var $self = $(this);
				if ( $self.prop('checked') ) {
					control.value[control.id].same = 'same';
					$components.stop().slideUp();
					$rowLabel.hide();
					$sameLabel.text( $sameLabel.data('same') );
				} else {
					control.value[control.id].same = '';
					$components.stop().slideDown();
					$rowLabel.show();
					$sameLabel.text( $sameLabel.data('notsame') );
				}
				$field.val( JSON.stringify( control.value[control.id] ) ).trigger('change');
			});
			if ( $obj.prop('checked') ) {
				$components.hide();
				$rowLabel.hide();
				$sameLabel.text( $sameLabel.data('same') );
			}
		},

		getSelectedData: function( $obj, data, std ) {
			var $op = $('.selected', $obj ),
				dataget = $op.data( data );
			return dataget ? dataget : std;
		},

		fontStyle: function($style) {
			var control = this,	$field = $(control.field, control.container);
			// Font style
			$('.button', $style).on('click', function(){
				var clickedStyle = $(this).data('style');
				if ( 'underline' == clickedStyle ) {
					$('.button.selected[data-style=linethrough]', $style).removeClass('selected');
				}
				if ( 'linethrough' == clickedStyle ) {
					$('.button.selected[data-style=underline]', $style).removeClass('selected');
				}
				if ( 'nostyle' == clickedStyle ) {
					$('.button:not([data-style=nostyle])', $style).removeClass('selected');
				}
				if ( 'nostyle' != clickedStyle ) {
					$('.button[data-style=nostyle]', $style).removeClass('selected');
				}
				// Mark this as selected
				$(this).toggleClass('selected');

				// Check which buttons are set
				$('.button', $style).each(function(){
					if ( $(this).hasClass('selected') ) {
						control.value[control.id][$(this).data('style')] = $(this).data('style');
					} else {
						control.value[control.id][$(this).data('style')] = '';
					}
				});
				$field.val( JSON.stringify( control.value[control.id] ) ).trigger('change');
			});
		},

		textTransform: function($texttransform){
			var control = this,	$field = $(control.field, control.container);
			$('.button', $texttransform).on('click', function(){
				var clickedTextTrans = $(this).data('texttransform');
				// Mark this as selected
				$('.button', $texttransform).not(this).removeClass('selected');
				$(this).toggleClass('selected');

				if ( 'notexttransform' == clickedTextTrans ) {
					$('.button:not([data-texttransform=notexttransform])', $texttransform).removeClass('selected');
				}
				if ( 'notexttransform' != clickedTextTrans ) {
					$('.button[data-texttransform=notexttransform]', $texttransform).removeClass('selected');
				}
				control.value[control.id].texttransform = control.getSelectedData( $texttransform, 'texttransform' );
				$field.val( JSON.stringify( control.value[control.id] ) ).trigger('change');
			});
		},

		textAlign: function($align){
			var control = this,	$field = $(control.field, control.container);
			$('.button', $align).on('click', function(){
				var clickedAlign = $(this).data('align');
				// Mark this as selected
				$('.button', $align).not(this).removeClass('selected');
				$(this).toggleClass('selected');

				if ( 'noalign' == clickedAlign ) {
					$('.button:not([data-align=noalign])', $align).removeClass('selected');
				}
				if ( 'noalign' != clickedAlign ) {
					$('.button[data-align=noalign]', $align).removeClass('selected');
				}
				control.value[control.id].align = control.getSelectedData( $align, 'align' );
				$field.val( JSON.stringify( control.value[control.id] ) ).trigger('change');
			});
		},

		fontFamily: function($obj) {
			var control = this,	$field = $(control.field, control.container);
			$obj.on('change', function(){
				control.value[control.id].family = $.parseJSON( $('option:selected', $(this)).val() );
				$field.val( JSON.stringify( control.value[control.id] ) ).trigger('change');
			});
		},

		inputOption: function($obj, key){
			var control = this, $field = $(control.field, control.container ),
				timer;

			$obj.on('keyup', function(){
				var value = $(this).val();
				if ( 'blogname' == key ) {
					$('.customize-control-themify_logo').find('.site-name').each(function(){
						$(this).val( value );
					});
				}
				clearTimeout(timer);
				timer = setTimeout(function(){
					$.post(
						ajaxurl,
						{
							'action': 'themify_customizer_save_option',
							'option': key,
							'value': value,
							'nonce' : themifyCustomizerControls.nonce
						},
						function(data) {
							if ( 'saved' == data ) {
								// Set timestamp to force live preview reload
								control.value[control.id].stamp = new Date().getTime();
								$field.val( JSON.stringify( control.value[control.id] ) ).trigger('change');
							}
						}
					);
				}, 750);
			});
		},

		saveOption: function(key, value){
			var control = this;
			$.post(
				ajaxurl,
				{
					'action': 'themify_customizer_save_option',
					'option': key,
					'value': value,
					'nonce' : themifyCustomizerControls.nonce
				},
				function(data) {
					if ( 'saved' == data ) {
						control.saveOptionCallback();
					}
				}
			);
		},

		saveOptionCallback: function() {
			// if you use saveOption, redefine this callback in the extended object
		},

		changeMode: function(key) {
			var control = this,	$field = $(control.field, control.container);
			$(key + '-mode', control.container ).each(function(){
				$(this).on('click', function(){
					var $self = $(this);
					$(key + '-mode-wrap', control.container).hide();
					$(key + '-' + $self.val() + '-mode', control.container).show();

					control.value[control.id].mode = $self.val();
					$field.val( JSON.stringify( control.value[control.id] ) ).trigger('change');
				});
			});
			$(key + '-mode-wrap', control.container).hide();
			$(key + '-' + $('input[type=radio]' + key + '-mode:checked').val() + '-mode', control.container).show();
		}

	});
	/***************************************************************************
	 * ThemifyControl End
	 ***************************************************************************/

	////////////////////////////////////////////////////////////////////////////
	// Font Control Start
	////////////////////////////////////////////////////////////////////////////
	api.ThemifyFont = api.ThemifyControl.extend({

		field: '.themify_font_control',

		ready: function() {
			var control = this,
				$field = $(control.field, control.container);

			if ( '' != $field.val() ) {
				control.value[control.id] = $.parseJSON( $field.val() );
			} else {
				control.value[control.id] = {};
			}

			// Checkbox to hide controls
			control.collapse( $('.disable-control', control.container) );

			// Font family
			control.fontFamily( $('.themify_font_family', control.container) );

			// Font size numeric
			control.input( $('.font_size_num', control.container), 'sizenum' );

			// Font size unit
			control.dropdown( $('.font_size_unit', control.container), 'sizeunit' );

			// Line height numeric
			control.input( $('.font_line_num', control.container), 'linenum' );

			// Line height unit
			control.dropdown( $('.font_line_unit', control.container), 'lineunit' );

			// Font style
			control.fontStyle( $('.themify_font_style', control.container ) );

			// Text transform
			control.textTransform( $('.themify_text_transform', control.container ) );

			// Text align
			control.textAlign( $('.themify_font_align', control.container ) );
		}
	});
	api.controlConstructor.themify_font = api.ThemifyFont;
	api.controlConstructor.themify_text_decoration = api.ThemifyFont;
	////////////////////////////////////////////////////////////////////////////
	// Font Control End
	////////////////////////////////////////////////////////////////////////////



	////////////////////////////////////////////////////////////////////////////
	// Logo Control Start
	////////////////////////////////////////////////////////////////////////////
	api.ThemifyLogo = api.ThemifyControl.extend({

		field: '.themify_logo_control',

		ready: function() {
			var control = this,
				$field = $(control.field, control.container);

			if ( '' != $field.val() ) {
				control.value[control.id] = $.parseJSON( $field.val() );
			} else {
				control.value[control.id] = {};
			}

			// Logo Mode Changer
			control.changeMode( '.logo' );

			// Site title
			control.inputOption( $('.site-name', control.container), 'blogname' );

			// Site title link
			control.input( $('.site-link', control.container), 'link' );

			// Open Media Library
			control.openMedia();

			// Image width and height
			control.input( $('.img-width', control.container), 'imgwidth' );
			control.input( $('.img-height', control.container), 'imgheight' );

			// Checkbox to hide controls
			control.collapse( $('.disable-control', control.container) );

			// Font family
			control.fontFamily( $('.themify_font_family', control.container) );

			// Font size numeric
			control.input( $('.font_size_num', control.container), 'sizenum' );

			// Font size unit
			control.dropdown( $('.font_size_unit', control.container), 'sizeunit' );

			// Line height numeric
			control.input( $('.font_line_num', control.container), 'linenum' );

			// Line height unit
			control.dropdown( $('.font_line_unit', control.container), 'lineunit' );

			// Font style
			control.fontStyle( $('.themify_font_style', control.container ) );

			// Text transform
			control.textTransform( $('.themify_text_transform', control.container ) );

			// Text align
			control.textAlign( $('.themify_font_align', control.container ) );

			// Color Picker
			control.pickColor();
		}
	});
	api.controlConstructor.themify_logo = api.ThemifyLogo;
	////////////////////////////////////////////////////////////////////////////
	// Logo Control End
	////////////////////////////////////////////////////////////////////////////

	////////////////////////////////////////////////////////////////////////////
	// Tagline Control Start
	////////////////////////////////////////////////////////////////////////////
	api.ThemifyTagline = api.ThemifyControl.extend({

		field: '.themify_tagline_control',

		ready: function() {
			var control = this,
				$field = $(control.field, control.container);

			if ( '' != $field.val() ) {
				control.value[control.id] = $.parseJSON( $field.val() );
			} else {
				control.value[control.id] = {};
			}

			// Logo Mode Changer
			control.changeMode( '.tagline' );

			// Site title
			control.inputOption( $('.site-description', control.container), 'blogdescription' );

			// Open Media Library
			control.openMedia();

			// Image width and height
			control.input( $('.img-width', control.container), 'imgwidth' );
			control.input( $('.img-height', control.container), 'imgheight' );

			// Checkbox to hide controls
			control.collapse( $('.disable-control', control.container) );

			// Font family
			control.fontFamily( $('.themify_font_family', control.container) );

			// Font size numeric
			control.input( $('.font_size_num', control.container), 'sizenum' );

			// Font size unit
			control.dropdown( $('.font_size_unit', control.container), 'sizeunit' );

			// Line height numeric
			control.input( $('.font_line_num', control.container), 'linenum' );

			// Line height unit
			control.dropdown( $('.font_line_unit', control.container), 'lineunit' );

			// Font style
			control.fontStyle( $('.themify_font_style', control.container ) );

			// Text transform
			control.textTransform( $('.themify_text_transform', control.container ) );

			// Text align
			control.textAlign( $('.themify_font_align', control.container ) );

			// Color Picker
			control.pickColor();
		}
	});
	api.controlConstructor.themify_tagline = api.ThemifyTagline;
	////////////////////////////////////////////////////////////////////////////
	// Logo Control End
	////////////////////////////////////////////////////////////////////////////

	////////////////////////////////////////////////////////////////////////////
	// Background Control Start
	////////////////////////////////////////////////////////////////////////////
	api.ThemifyBackground = api.ThemifyControl.extend({

		field: '.themify_background_control',

		noImage: function($obj) {
			var control = this,	$field = $(control.field, control.container ),
				$hideElements = $('.open-media-wrap, .image-label, .background-style, .background-position', control.container);

			$obj.on('click', function(){
				var $self = $(this);
				if ( $self.prop('checked') ) {
					control.value[control.id].noimage = 'noimage';
					$hideElements.stop().slideUp();
				} else {
					control.value[control.id].noimage = '';
					$hideElements.stop().slideDown();
				}
				$field.val( JSON.stringify( control.value[control.id] ) ).trigger('change');
			});
			if ( $obj.prop('checked') ) {
				$hideElements.hide();
			}
		},

		ready: function() {
			var control = this,
				$field = $(control.field, control.container);

			if ( '' != $field.val() ) {
				control.value[control.id] = $.parseJSON( $field.val() );
			} else {
				control.value[control.id] = {};
			}

			// Checkbox to hide controls
			control.noImage( $('.disable-control', control.container) );

			// Open Media Library
			control.openMedia();

			// Image style
			control.dropdown( $('.image-style', control.container), 'style' );

			// Image position
			control.dropdown( $('.position-style', control.container), 'position' );

			// Color Picker
			control.pickColor();

			// Color Transparent
			control.transparent( $('.color-transparent', control.container) );
		}
	});
	api.controlConstructor.themify_background = api.ThemifyBackground;
	////////////////////////////////////////////////////////////////////////////
	// Background Control End
	////////////////////////////////////////////////////////////////////////////

	////////////////////////////////////////////////////////////////////////////
	// Color Control Start
	////////////////////////////////////////////////////////////////////////////
	api.ThemifyColor = api.ThemifyControl.extend({

		field: '.themify_color_control',

		ready: function() {
			var control = this,
				$field = $(control.field, control.container);

			if ( '' != $field.val() ) {
				control.value[control.id] = $.parseJSON( $field.val() );
			} else {
				control.value[control.id] = {};
			}

			// Color Picker
			control.pickColor();

			// Color Transparent
			control.transparent( $('.color-transparent', control.container) );
		}
	});
	api.controlConstructor.themify_color = api.ThemifyColor;
	////////////////////////////////////////////////////////////////////////////
	// Color Control End
	////////////////////////////////////////////////////////////////////////////

	////////////////////////////////////////////////////////////////////////////
	// Image Control Start
	////////////////////////////////////////////////////////////////////////////
	api.ThemifyImage = api.ThemifyBackground.extend({

		field: '.themify_image_control',

		ready: function() {
			var control = this,
				$field = $(control.field, control.container);

			if ( '' != $field.val() ) {
				control.value[control.id] = $.parseJSON( $field.val() );
			}

			// Open Media Library
			control.openMedia();
		}
	});
	api.controlConstructor.themify_image = api.ThemifyImage;
	////////////////////////////////////////////////////////////////////////////
	// Image Control End
	////////////////////////////////////////////////////////////////////////////

	////////////////////////////////////////////////////////////////////////////
	// Border Control Start
	////////////////////////////////////////////////////////////////////////////
	api.ThemifyBorder = api.ThemifyControl.extend({

		field: '.themify_border_control',

		ready: function() {
			var control = this,
				$field = $(control.field, control.container);

			if ( '' != $field.val() ) {
				control.value[control.id] = $.parseJSON( $field.val() );
			} else {
				var initObj = {
					'color' : '',
					'opacity' : '',
					'style' : '',
					'width' : ''
				};
				control.value[control.id] = {};
				control.value[control.id].top = initObj;
				control.value[control.id].left = initObj;
				control.value[control.id].bottom = initObj;
				control.value[control.id].right = initObj;
			}

			// Checkbox to hide controls
			control.collapse( $('.disable-control', control.container) );

			// Border color
			control.pickBorderColor();

			// Border style
			control.dropdownBorderSame( $('.border-style', control.container) );

			// Border width
			control.dimensionSame( $('.dimension-width', control.container) );

			// Hide components leaving only one
			control.hideComponentsSame( $('.same', control.container) );
		}
	});
	api.controlConstructor.themify_border = api.ThemifyBorder;
	////////////////////////////////////////////////////////////////////////////
	// Border Control End
	////////////////////////////////////////////////////////////////////////////

	////////////////////////////////////////////////////////////////////////////
	// Margin Control Start
	////////////////////////////////////////////////////////////////////////////
	api.ThemifyMargin = api.ThemifyControl.extend({

		field: '.themify_margin_control',

		ready: function() {
			var control = this,
				$field = $(control.field, control.container);

			if ( '' != $field.val() ) {
				control.value[control.id] = $.parseJSON( $field.val() );
			} else {
				var initObj = {
					'width' : '',
					'unit'  : 'px'
				};
				control.value[control.id] = {};
				control.value[control.id].top = initObj;
				control.value[control.id].left = initObj;
				control.value[control.id].bottom = initObj;
				control.value[control.id].right = initObj;
			}

			// Checkbox to hide controls
			control.collapse( $('.disable-control', control.container) );

			// Margin width
			control.dimensionSame( $('.dimension-width', control.container) );

			// Margin unit
			control.dropdownSame( $('.dimension-unit', control.container), 'unit' );

			// Auto
			control.autoSame( $('.auto-prop', control.container) );

			// Hide components leaving only one
			control.hideComponentsSame( $('.same', control.container) );
		}
	});
	api.controlConstructor.themify_margin = api.ThemifyMargin;
	////////////////////////////////////////////////////////////////////////////
	// Margin Control End
	////////////////////////////////////////////////////////////////////////////

	////////////////////////////////////////////////////////////////////////////
	// Padding Control Start
	////////////////////////////////////////////////////////////////////////////
	api.ThemifyPadding = api.ThemifyMargin.extend({

		field: '.themify_padding_control'

	});
	api.controlConstructor.themify_padding = api.ThemifyPadding;
	////////////////////////////////////////////////////////////////////////////
	// Padding Control End
	////////////////////////////////////////////////////////////////////////////

	////////////////////////////////////////////////////////////////////////////
	// Width Control Start
	////////////////////////////////////////////////////////////////////////////
	api.ThemifyWidth = api.ThemifyControl.extend({

		field: '.themify_width_control',

		ready: function() {
			var control = this,
				$field = $(control.field, control.container);

			if ( '' != $field.val() ) {
				control.value[control.id] = $.parseJSON( $field.val() );
			} else {
				control.value[control.id] = {
					'width' : '',
					'unit'  : 'px',
					'auto'  : ''
				};
			}

			// Width width
			control.dimension( $('.dimension-width', control.container) );

			// Width unit
			control.dropdown( $('.dimension-unit', control.container), 'unit' );

			// Auto
			control.auto( $('.auto-prop', control.container) );
		}
	});
	api.controlConstructor.themify_width = api.ThemifyWidth;
	////////////////////////////////////////////////////////////////////////////
	// Width Control End
	////////////////////////////////////////////////////////////////////////////

	////////////////////////////////////////////////////////////////////////////
	// Height Control Start
	////////////////////////////////////////////////////////////////////////////
	api.ThemifyHeight = api.ThemifyWidth.extend({

		field: '.themify_height_control'

	});
	api.controlConstructor.themify_height = api.ThemifyHeight;
	////////////////////////////////////////////////////////////////////////////
	// Height Control End
	////////////////////////////////////////////////////////////////////////////

	////////////////////////////////////////////////////////////////////////////
	// Position Control Start
	////////////////////////////////////////////////////////////////////////////
	api.ThemifyPosition = api.ThemifyControl.extend({

		field: '.themify_position_control',

		dropdownPosition: function($obj, key) {
			var control = this,	$field = $(control.field, control.container ),
				initial = $obj.find('option:selected').val();

			$obj.on('change', function(){
				var $select = $(this), value = $('option:selected', $select).val();
				control.value[control.id][key] = value;
				$field.val( JSON.stringify( control.value[control.id] ) ).trigger('change');

				if ( '' != value && 'static' != value ) {
					$select.closest('.themify-customizer-brick').parent().find('.position-wrap').show();
				} else {
					$select.closest('.themify-customizer-brick').parent().find('.position-wrap').hide();
				}
			});

			if ( '' != initial && 'static' != initial ) {
				$obj.closest('.themify-customizer-brick').parent().find('.position-wrap').show();
			} else {
				$obj.closest('.themify-customizer-brick').parent().find('.position-wrap').hide();
			}
		},

		ready: function() {
			var control = this,
				$field = $(control.field, control.container);

			if ( '' != $field.val() ) {
				control.value[control.id] = $.parseJSON( $field.val() );
			} else {
				control.value[control.id] = {
					'position' : ''
				};
			}

			// Position
			control.dropdownPosition( $('.position', control.container), 'position' );

			// Position value
			control.dimensionSame( $('.dimension-width', control.container) );

			// Position unit
			control.dropdownSame( $('.dimension-unit', control.container), 'unit' );

			// Auto
			control.autoSame( $('.auto-prop', control.container) );
		}
	});
	api.controlConstructor.themify_position = api.ThemifyPosition;
	////////////////////////////////////////////////////////////////////////////
	// Position Control End
	////////////////////////////////////////////////////////////////////////////

	////////////////////////////////////////////////////////////////////////////
	// CustomCSS Control Start
	////////////////////////////////////////////////////////////////////////////
	api.ThemifyCustomCSS = api.ThemifyControl.extend({

		field: '.themify_customcss_control',

		clean: function ( key, value ) {
			if ( typeof value === 'string' ) {
				return value
					.replace(/[\n]/g, '')
					.replace(/[\r]/g, '')
					.replace(/[\t]/g, '')
					;
			}
			return value;
		},

		markup: function($obj, key) {
			var control = this,	$field = $(control.field, control.container);
			$obj.on( 'keyup paste', function (e) {
				if ( 'paste' == e.type ) {
					setTimeout( function() {
						control.value[control.id][key] = $obj.val();
						$field.val( JSON.stringify( control.value[control.id], control.clean ) ).trigger('change');
						if ( customCSSInit ) {
							customCSSInit = false;
						}
					}, 1 );
				} else {
					control.value[control.id][key] = $obj.val();
					$field.val( JSON.stringify( control.value[control.id], control.clean ) ).trigger('change');
					if ( customCSSInit ) {
						customCSSInit = false;
					}
				}
			});
		},

		expand: function( container, $customCSS ) {
			var $blockToHide = $customCSS.closest('.themify-customizer-brick');

			// Expand panel hides custom css in accordion, adds markup and attaches needed events
			$('.themify-expand', container).on('click', function(e){
				e.preventDefault();
				var $expand = $('<div class="customize-control customcss-expand"><a class="themify-contract ti ti-close"></a><textarea class="customcss">' + $customCSS.val() + '</textarea></div>').hide();
				$blockToHide.stop().slideUp();
				$expand.prependTo( $('#widgets-right')).slideDown();
				$expand.find('.customcss').on('keyup paste', function(e) {
					if ( 'paste' == e.type ) {
						setTimeout( function() {
							$customCSS.val( $(this).val() ).trigger('keyup');
						}, 1 );
					} else {
						$customCSS.val( $(this).val() ).trigger('keyup');
					}
				});

				// Contract panel removes markup and events and reveals custom css in accordion
				$expand.find('.themify-contract').on('click', function(e){
					e.preventDefault();
					$(this).off('click').closest('.customize-control').remove();
					$expand.find('.customcss').off('keyup paste');
					$blockToHide.stop().slideDown();
				});
			});
		},

		ready: function() {
			var control = this,
				$field = $(control.field, control.container),
				$customCSS = $('.customcss', control.container);

			try {
				if ( '' != $field.val() ) {
					var currentVal =  $field.val(),
						tempcss = currentVal.replace('{"css":"', '').replace('"}', '').replace(/\\/g, "\\\\").replace(/"/g, '\\"'),
						customcssData = '{"css":"' + tempcss + '"}';
					control.value[control.id] = $.parseJSON( customcssData );
				} else {
					control.value[control.id] = {
						'css' : ''
					};
				}
				// Custom CSS textarea
				control.markup( $customCSS, 'css' );
			} catch(e) {
				window.console && console.log && console.log(e);
				control.value[control.id] = {
					'css' : ''
				};
				// Custom CSS textarea
				control.markup( $customCSS, 'css' );
			}

			// Initialize expand/contract action
			control.expand( control.container, $customCSS );
		}
	});
	api.controlConstructor.themify_customcss = api.ThemifyCustomCSS;
	////////////////////////////////////////////////////////////////////////////
	// CustomCSS Control End
	////////////////////////////////////////////////////////////////////////////

	////////////////////////////////////////////////////////////////////////////
	// Image Select Control Start
	////////////////////////////////////////////////////////////////////////////
	api.ThemifyImageSelect = api.ThemifyControl.extend({

		field: '.themify_image_select_control',

		ready: function() {
			var control = this, $field = $(control.field, control.container);

			if ( '' != $field.val() ) {
				control.value[control.id] = $.parseJSON( $field.val() );
			} else {
				control.value[control.id] = {
					'type' : '',
					'selected' : ''
				};
			}

			$('.image-select', control.container).on('click', function (e) {
				e.preventDefault();
				control.value[control.id].selected = $(this).data('option');
				$field.val( JSON.stringify( control.value[control.id] ) ).trigger('change');
			});
		}
	});
	api.controlConstructor.themify_image_select = api.ThemifyImageSelect;
	////////////////////////////////////////////////////////////////////////////
	// Image Select Control End
	////////////////////////////////////////////////////////////////////////////

	////////////////////////////////////////////////////////////////////////////
	// Clear Control Start
	////////////////////////////////////////////////////////////////////////////
	api.ThemifyClear = api.ThemifyControl.extend({

		field: '.themify_clear_control',

		clearing: false,

		saveOptionCallback: function() {
			// Save and reload
			$('#customize-header-actions').find('.save').trigger('click');
		},

		ready: function() {
			var control = this;

			api.bind('saved', function(){
				if ( api.ThemifyClear.field ) {
					window.top.location.reload(true);
					api.ThemifyClear.field = false;
				}
			});

			$('.clearall', control.container).on( 'click', function() {
				if ( window.confirm(themifyCustomizerControls.clearMessage) ) {
					// Tell the event hooked to 'saved' that we want to reload.
					api.ThemifyClear.field = true;

					// Clear all option fields
					$('.themify-customizer-value-field').each(function(){
						$(this).val('').trigger('change');
					});

					// Restore site name
					var sessionSiteName = $('.customize-control-themify_logo').find('.site-name').val(),
						sessionTagline = $('.customize-control-themify_tagline').find('.site-name').val(),
						currentSiteName = $(this).data('sitename'),
						currentTagline = $(this).data('tagline');

					if ( sessionSiteName != currentSiteName || sessionTagline != currentTagline ) {
						// Save will be triggered once the option saving succeeds
						control.saveOption('blogname', currentSiteName);
						control.saveOption('blogdescription', currentTagline);
					} else {
						// Trigger save button manually
						control.saveOptionCallback();
					}
				}
			});
		}
	});
	api.controlConstructor.themify_clear = api.ThemifyClear;
	////////////////////////////////////////////////////////////////////////////
	// Clear Control End
	////////////////////////////////////////////////////////////////////////////

})( wp, jQuery );