<?php
/*
Copyright (c) 2010-2018 Box Hill LLC

All Rights Reserved

No part of this software may be reproduced, copied, modified or adapted, without the prior written consent of Box Hill LLC.

Commercial use and distribution of any part of this software is not allowed without express and prior written consent of Box Hill LLC.


 */

/**
 * Logging module
 *
 * Relies on EasyLogger being installed and active - does nothing if it's not
 */

/**
 * Class EasyLogger
 */
/** @noinspection PhpMultipleClassesDeclarationsInOneFile */
class EasyRecipeLogger {

    /**
     * @param $logFile
     * @return EasyLoggerLog
     */

    static function getLog($logFile) {
        $plugins = get_option('active_plugins', array());
        if (in_array("easylogger/easylogger.php", $plugins)) {
            /** @noinspection PhpUndefinedClassInspection */
            return EasyLogger::getLog($logFile);
        }
        return EasyRecipeDummyLogger::getinstance();
    }
}


/**
 * Class EasyLoggerLog
 */
/** @noinspection PhpMultipleClassesDeclarationsInOneFile */
class EasyRecipeDummyLogger {
    static private $instance;

    /**
     * @return EasyRecipeDummyLogger
     */
    static function getinstance() {
        if (!self::$instance) {
            self::$instance = new EasyRecipeDummyLogger();
        }
        return self::$instance;
    }

    /**
     * @param $msg
     */
    function comment($msg) {
    }

    /**
     * @param $level
     */
    function disable($level) {
    }

    /**
     * @param $level
     */
    function enable($level) {
    }

    /**
     * @param $msg
     */
    function debug($msg) {
    }

    /**
     * @param $msg
     */
    function info($msg) {
    }

    /**
     * @param $msg
     */
    function warn($msg) {
    }

    /**
     * @param $msg
     */
    function error($msg) {
    }

    /**
     * @param $msg
     */
    function fatal($msg) {
    }
}

