<?php
/**
 * The template for displaying archive pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package aaa
 */

get_header();
?>

	<main id="primary" class="site-main">

		<?php if ( have_posts() ) : ?>

			<header class="page-header">
				<h1>L'auteur</h1>
				<p><i>“Passionné de courgette ? N'exagérons rien. Mais intéressé par la cuisine, oui, cette activité humaine qui consiste à préparer à manger pour sa famille.“</i></p>
				<p>Pierre Réguer, auteur de ce site, a créé et dirigé pendant 30 ans <a href="https://expression-bretagne.com/">Expression</a>, agence de communication axée sur l'information au service des entreprises et collectivités.</p>
				<p>Pierre Réguer est également le créateur d'autres sites culinaires&nbsp;:</p>
				<ul>
					<li><a href="https://cuisiner-les-courgettes.com/"><b>Cuisine à l'Ouest</b></a>, qui parle de cuisine d'inspiration bretonne et de recettes un peu à l'Ouest</li>
					<li><b>Cuisinons les légumes</b>, aujourd'hui disparu mais qui a pendant près de dix ans, pour le compte de Prince de Bretagne, mis en œuvre une véritable démarche de pédagogie pour aider à manger davantage de légumes.</li>
				</ul>	

				<p><a href="https://www.linkedin.com/in/pierre-reguer-29600/">Pierre Réguer sur LinkedIn</a></p>
				<h2>Les dernières recettes de l'auteur</h2>	

				
			</header><!-- .page-header -->

			<?php
			/* Start the Loop */
			while ( have_posts() ) :
				the_post();
				get_template_part( 'template-parts/content', 'vignette' );
			endwhile;

				the_posts_pagination( array(
    				'prev_text'          => '<< Préc&nbsp;&nbsp;',
    				'next_text'          => '&nbsp;&nbsp;Suiv >>',
    				'screen_reader_text' => 'Navigation parmi les articles',
    				'before_page_number' => '<span class="meta-nav screen-reader-text">' . 'Page' . ' </span>',
    				'after_page_number'  => '&nbsp;&nbsp;',
    				'mid_size'           => 2,
    				'end_size'           => 2,
				) );

		else :
			get_template_part( 'template-parts/content', 'none' );
		endif;
			?>

	</main><!-- #main -->

<?php
get_sidebar();
get_footer();
