<?php
/**
 * The template for displaying archive pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package aaa
 */

get_header();
?>

	<main id="primary" class="site-main">

		<?php if ( have_posts() ) : ?>

			<header class="page-header">

				<?php
				the_archive_title( '<h1 class="page-title">', '</h1>' );
				the_archive_description( '<div class="archive-description">', '</div>' );
				?>
			</header><!-- .page-header -->

			<?php
			/* Start the Loop */
			while ( have_posts() ) :
				the_post();
				get_template_part( 'template-parts/content', 'vignette' );
			endwhile;

				the_posts_pagination( array(
    				'prev_text'          => '<< Préc&nbsp;&nbsp;',
    				'next_text'          => '&nbsp;&nbsp;Suiv >>',
    				'screen_reader_text' => 'Navigation parmi les articles',
    				'before_page_number' => '<span class="meta-nav screen-reader-text">' . 'Page' . ' </span>',
    				'after_page_number'  => '&nbsp;&nbsp;',
    				'mid_size'           => 2,
    				'end_size'           => 2,
				) );

		else :
			get_template_part( 'template-parts/content', 'none' );
		endif;
			?>

	</main><!-- #main -->

<?php
get_sidebar();
get_footer();
