<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Nouvelle_vague
 */

?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<div>

		<header class="entry-header">
			<?php
			if ( is_singular() ) :
				the_title( '<h1 class="entry-title">', '</h1>' );
			else :
				the_title( '<h2 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' );
			endif;

			/*
			if ( 'post' === get_post_type() ) :
				?>
				<div class="entry-meta">
					<?php
					nouvelle_vague_posted_on();
					nouvelle_vague_posted_by();
					?>
				</div><!-- .entry-meta -->
			<?php endif; 
			*/
			?>
		</header><!-- .entry-header -->

		<section>
			<?php nouvelle_vague_post_thumbnail(); ?>

			<div class="entry-content">
				<?php
				the_content( sprintf(
					wp_kses(
						/* translators: %s: Name of current post. Only visible to screen readers */
						__( 'Continue reading<span class="screen-reader-text"> "%s"</span>', 'nouvelle-vague' ),
						array(
							'span' => array(
								'class' => array(),
							),
						)
					),
					get_the_title()
				) );

				wp_link_pages( array(
					'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'nouvelle-vague' ),
					'after'  => '</div>',
				) );
				?>
			</div><!-- .entry-content -->
		</section>

		<footer class="entry-footer">
			<?php //nouvelle_vague_entry_footer(); ?>
		</footer><!-- .entry-footer -->

	</div>
</article><!-- #post-<?php the_ID(); ?> -->
