<?php
/**
 * The main template file
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Nouvelle_vague
 */

get_header();
?>




	<section id="main" role="main">

		<article id="home-slider">
			<div>

				<div class="slider">
<?php
if( have_rows("slider", 2) ): 

	while( have_rows("slider", 2) ): the_row(); 
		$slogan = get_sub_field("slogan-slider");
		$visuel = get_sub_field("visuel-slider");
		$url = get_sub_field("url-lien-slider");
		$url = ($url == "" ? "#" : $url);
		$destination = get_sub_field("destination-lien-slider");
		//print_r($visuel);
?>

					<div><a href="<?=$url;?>" title="<?=strip_tags($slogan);?>" target="<?=$destination;?>"><img src="<?=$visuel["url"];?>" alt="<?=strip_tags($slogan);?>" /></a></div>
<?php
	endwhile;
endif;
?>
				</div>

			</div>
		</article>


		<article id="home-cibles">
			<div>
<?php
if( have_rows("prestations", 2) ): 
?>
					<ul>
<?php
	while( have_rows("prestations", 2) ): the_row(); 

		$visuel_prestation = get_sub_field("visuel-prestation");
		$intitule_prestation = get_sub_field("intitule-prestation");
		$page_prestation = get_sub_field("page-prestation");
		//print_r($page_prestation);
?>
						<li>
							<a href="<?=$page_prestation;?>" title="<?=strip_tags($intitule_prestation);?>">
								<strong><?=$intitule_prestation;?></strong>
								<img src="<?=$visuel_prestation["url"];?>" alt="<?=strip_tags($intitule_prestation);?>" />
							</a>
						</li>
<?php
	endwhile;
?>
					</ul>
<?php
endif;
?>
			</div>
		</article>

		<article id="home-presentation">
			<div>
				<!-- Bloc 1 -->
<?php
$bloc1 = get_field("bloc1", 2);	
$visuel_bloc1 = $bloc1["visuel-bloc1"];
$titre_bloc1 = $bloc1["titre-bloc1"];
$accroche_bloc1 = $bloc1["accroche-bloc1"];
$lien_bloc1 = $bloc1["lien-bloc1"];
?>

				<div id="bloc1">
					<img src="<?=$visuel_bloc1["url"];?>" alt="<?=strip_tags($titre_bloc1);?>" />
					<div>
						<h2><?=$titre_bloc1;?></h2>
						<p><?=$accroche_bloc1;?><br/>
							<a href="<?=$lien_bloc1;?>" title="En savoir plus" class="savoir-plus">En savoir +</a><br/>
							<a href="https://widget.s.production.wavy.team/widget?subdomain=nouvellevague" title="Prendre rendez-vous" class="rendez-vous" target="_blank">Prendre RDV en ligne</a>
						</p>
					</div>
				</div>
				<!-- Bloc 2 -->
<?php
$bloc2 = get_field("bloc2", 2);	
$visuel_bloc2 = $bloc2["visuel-bloc2"];
$titre_bloc2 = $bloc2["titre-bloc2"];
$accroche_bloc2 = $bloc2["accroche-bloc2"];
$lien_bloc2 = $bloc2["lien-bloc2"];
?>

				<div id="bloc2">
					<div>
						<h2><?=$titre_bloc2;?></h2>
						<p><?=$accroche_bloc2;?><br/>
							<a href="<?=$lien_bloc2;?>" title="En savoir plus" class="savoir-plus">En savoir +</a><br/>
							<a href="https://widget.s.production.wavy.team/widget?subdomain=nouvellevague" title="Prendre rendez-vous" class="rendez-vous" target="_blank">Prendre RDV en ligne</a>
						</p>
					</div>
					<img src="<?=$visuel_bloc2["url"];?>" alt="<?=strip_tags($titre_bloc2);?>" />
				</div>

			</div>
		</article>


		<article id="home-actualites">
			<div>

				<h2>Les actualités</h2>
				<div class="slider">
<?php
$recent_posts = get_posts(array(
	'numberposts'	=> 10,
	'category'		=> 1,

));

if( $recent_posts ):

	foreach( $recent_posts as $recent ):
		//var_dump($recent);
		/*
		date_default_timezone_set("Europe/Paris");
		setlocale(LC_ALL, 'fr_FR');
		//$date = date("d.m.Y", strtotime($recent->post_date));
		$jour = date("d", strtotime($recent->post_date));
		$mois = date("F", strtotime($recent->post_date));
		$annee = date("Y", strtotime($recent->post_date));
		*/		
		$excerpt = get_excerpt_by_id($recent->ID);
		$post_image = wp_get_attachment_url( get_post_thumbnail_id($recent->ID) );
		//var_dump($recent);
?>	
					<a href="<?=get_permalink($recent->ID);?>" title="<?=$recent->post_title; ?>">
						<div>
							<div>
								<h3><?=$recent->post_title; ?></h3>
								<?=$excerpt;?><br/>
								<span class="savoir-plus">En savoir +</span>
							</div>
							<div>
								<img src="<?=$post_image;?>" alt="" />
							</div>
						</div>
					</a>
<?php
	endforeach; 

endif;
?>
			</div>
		</article>


		<article id="home-footer">
			<div>
				
				<div>
					<a href="<?=get_permalink(62);?>" title="Les prestations du salon de coiffure Nouvelle Vague">
						<img src="<?=get_template_directory_uri();?>/assets/pictures/home/prestations.png" alt="Les prestations" />
						<h2>Les prestations</h2>
						<span class="savoir-plus">En savoir +</span>
					</a>
				</div>
				<div>
					<a href="<?=get_permalink(66);?>" title="Les avantages du salon de coiffure Nouvelle Vague">
						<img src="<?=get_template_directory_uri();?>/assets/pictures/home/avantages.png" alt="Les avantages" />
						<h2>Les avantages</h2>
						<span class="savoir-plus">En savoir +</span>
					</a>
				</div>

			</div>
		</article>




	</section>


<?php
//get_sidebar();
get_footer();
