<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Nouvelle_vague
 */

?>
<!doctype html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="https://gmpg.org/xfn/11">

	<?php wp_head(); ?>


	<script type="text/javascript"><!--//--><![CDATA[//><!--   

	jQuery(function($) {

<?php
if ( is_front_page() && is_home() )
{
?>
			$(".slider").slick({
				dots: true,
				infinite: true,
				centerMode: false,
				slidesToShow: 1,
				slidesToScroll: 1,
				mobileFirst: true,
				arrows: false,
				autoplay: true
			});

<?php
}
?>

		
		$("#menu > a").click(function() {
			$("#menu > div").slideToggle();
			return false;
		})


		$("#footer .menu a").click(function() {
			if ($(this).attr("href") == "#")
			{	return false;
			}
		})


	});

	//--><!]]></script>		 


</head>

<body <?php body_class(); ?>>


	<!-- Header -->
	<header id="header">
		<div>	
			<div id="header-top">
				<div id="header-top-left">
					<a href="tel:0298679156" title="Contacter Nouvelle vague par téléphone" class="tel">02 98 67 91 56</a>
				</div>
				<div id="header-top-right">
					<a href="https://www.facebook.com/nouvellevaguecarantec/?fb_dtsg_ag=Adw1hNNItQSBXFCz0mafooq389wgQ9LJ4k1mfl5i3kZa5A%3AAdyIavTUIthxTweLAZCOa8CLGwZVDw3o7zHuWSj25PAwzw" class="facebook" title="Retrouvez-nous sur facebook" target="_blank"><img src="<?=get_template_directory_uri();?>/assets/pictures/header/facebook.png" alt="" /></a>
					<a href="https://www.instagram.com/nouvellevaguecarantec/" class="instagram" title="Retrouvez-nous sur Instagram" target="_blank"><img src="<?=get_template_directory_uri();?>/assets/pictures/header/instagram.png" alt="" /></a>
					<a href="https://widget.s.production.wavy.team/widget?subdomain=nouvellevague" class="rendez-vous" title="Prendre rendez-vous en ligne avec Nouvelle vague" target="_blank">PRENDRE RDV EN LIGNE </a>
				</div>
			</div>
			<div id="header-middle">
				<a href="<?=get_site_url();?>">
					<strong><?php bloginfo( 'name' ); ?></strong>
					<em>Salon de coiffure &amp; d'esth&eacute;tique</em>
					<span>CARANTEC</span>
				</a>
			</div>
			<nav id="menu" role="navigation">
				<a href="#" class="mobile" title="Menu"><img src="<?=get_template_directory_uri();?>/assets/pictures/header/burger.svg" alt="Menu" /></a>
				<div>

					<?php
					wp_nav_menu( array(
						'theme_location' => 'menu-1',
						'menu_id'        => 'primary-menu',
					) );
					?>

				</div>
			</nav>  
		</div>     
	</header>
