<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Nouvelle_vague
 */

?>

	<!-- Footer -->
	<footer id="footer">
		<div>
			<div id="footer-left">
				<a href="tel:0298679156" title="Contacter Nouvelle vague par téléphone" class="tel"><span>02 98 67 91 56</span></a>
				<nav class="menu" role="navigation">
					<h4>Plan du site</h4>
					<?php
					wp_nav_menu( array(
						'theme_location' => 'menu-1',
						'menu_id'        => 'primary-menu',
					) );
					?>
				</nav>
			</div>

			<div id="footer-middle">
				<div>
					<strong>SALON DE COIFFURE NOUVELLE VAGUE </strong>
					<span>10 RUE MARÉCHAL FOCH CARANTEC</span>
				</div>
				<iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d2634.874968699961!2d-3.917823884332311!3d48.66963387926953!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x4813e0144e0f2025%3A0x3294c8dae3ae045!2s10+Rue+Mar%C3%A9chal+Foch%2C+29660+Carantec!5e0!3m2!1sfr!2sfr!4v1538734699049" width="100%" height="265" frameborder="0" style="border:0" allowfullscreen></iframe>
			</div>

			<div id="footer-right">
				<ul>
					<li><a href="https://widget.s.production.wavy.team/widget?subdomain=nouvellevague" class="rendez-vous" title="Prendre rendez-vous en ligne avec Nouvelle vague" target="_blank">PRENDRE RDV EN LIGNE </a></li>
					<li><a href="https://www.facebook.com/nouvellevaguecarantec/?fb_dtsg_ag=Adw1hNNItQSBXFCz0mafooq389wgQ9LJ4k1mfl5i3kZa5A%3AAdyIavTUIthxTweLAZCOa8CLGwZVDw3o7zHuWSj25PAwzw" class="facebook" title="Retrouvez-nous sur facebook" target="_blank"><img src="<?=get_template_directory_uri();?>/assets/pictures/footer/facebook.png" alt="" /></a></li>
					<li><a href="https://www.instagram.com/nouvellevaguecarantec/" class="instagram" title="Retrouvez-nous sur Instagram" target="_blank"><img src="<?=get_template_directory_uri();?>/assets/pictures/footer/instagram.png" alt="" /></a></li>
				</ul>
				<div>
					<div>
						<strong>Horaires <span>Coiffure</span></strong>
						<table>
							<tr>
								<td class="label">LUNDI</td>
								<td>14h00 - 18h00</td>
							</tr>
							<tr>
								<td class="label">MARDI </td>
								<td>9h00 - 19h00</td>
							</tr>
							<tr>
								<td class="label">MERCREDI </td>
								<td>9h00 - 19h00</td>
							</tr>
							<tr>
								<td class="label">JEUDI </td>
								<td>9h00 - 19h00</td>
							</tr>
							<tr>
								<td class="label">VENDREDI</td>
								<td>9h00 - 19h00</td>
							</tr>
							<tr>
								<td class="label">SAMEDI</td>
								<td>8h30 - 17h30</td>
							</tr>
						</table>
						<br/>
						<strong>Horaires <span>Esth&eacute;tique</span></strong>
						<table>
							<tr>
								<td class="label">MARDI </td>
								<td>9h00 - 19h00</td>
							</tr>
							<tr>
								<td class="label">JEUDI </td>
								<td>9h00 - 19h00</td>
							</tr>
							<tr>
								<td class="label">VENDREDI</td>
								<td>9h00 - 19h00</td>
							</tr>
							<tr>
								<td class="label">SAMEDI</td>
								<td>9h - 17h</td>
							</tr>
						</table>
					</div>
					<p>
						<a href="<?=get_permalink(3);?>" title="">MENTIONS LÉGALES ET POLITIQUE DE CONFIDENTIALITÉ</a>
					</p>
				</div>
			</div>

		</div>
	</footer>

<?php wp_footer(); ?>

</body>
</html>
