<?php
add_action( 'wp_enqueue_scripts', 'theme_enqueue_styles' );
function theme_enqueue_styles() {
    wp_enqueue_style( 'parent-style', get_template_directory_uri() . '/style.css' );
}

/* Le filet de haut de page, sur le hook storfront_header  */

add_action( 'storefront_header', 'cavasso_filet',      10 ); 
    if ( ! function_exists( 'cavasso_filet' ) ) {
	    function cavasso_filet() { 
	         echo '<div id="filet"></div>';
	}
}	


/* Enlève les modules de page d'accueil  */

add_action('after_setup_theme','remove_fonction_parent');
function remove_fonction_parent() {
   remove_action('homepage','storefront_best_selling_products', 70);
   remove_action('homepage', 'storefront_product_categories', 20);
   remove_action('homepage', 'storefront_recent_products', 30);
}







/* Ajout du slider Meilleures ventes, accroché au hook*/

add_action( 'homepage', 'cavasso_slider_meilleures_ventes',      50 ); 
    if ( ! function_exists( 'cavasso_slider_meilleures_ventes' ) ) {
	    function cavasso_slider_meilleures_ventes() { 
  
             echo '<div id="slider-meilleures-ventes"><h2 class="titre-meilleures-ventes">Nos meilleures ventes</h2>';
	         echo do_shortcode("[products_slider slide_to_show='1' limit='5']");
             echo '</div> <!-- ferme slider-meilleures-ventes-->';

	}
}	



/* Ajout du bandeau cheval et des encadrés En ce moment et Nouveau sur le blog accrochés au hook*/

add_action( 'homepage', 'cavasso_bandeau_cheval',      50 ); 
	    function cavasso_bandeau_cheval() {    
             echo '<div id="evenements-cavasso"><h2>Les événements Cavasso</h2></div>';
             echo '<img id="bandeau-cheval" src="/wp-content/design/bandeau-cavasso.png">';
	
// L'ENCADRÉ EN CE MOMENT
// 1. on définit ce que l'on veut
$args = array(
    'post_type' => 'post',
	'category_name' => 'en-ce-moment',
    'posts_per_page' => 1,
);

// 2. on exécute la query
$my_query = new WP_Query($args);

// 3. on lance la boucle !
if($my_query->have_posts()) : while ($my_query->have_posts() ) : $my_query->the_post();


     echo '<a href="';
	the_permalink();
	echo '"><div id="en-ce-moment"><div class="contenant-texte-encadre"><h2 class="surtitre-encadre">En ce moment<h3 class="titre-encadre">';
    the_title();
    echo '</h3>';
    the_excerpt();
	echo '</div><!--Ferme contenant-texte-encadre--><div class="image-encadre" style="background-image: url(';	
	the_post_thumbnail_url( $medium );	
	echo')"></div><!-- ferme image-encadre --></div><!--ferme #en-ce-moement--></a>';
			
			
			
			
   

endwhile;
endif;

// 4. On réinitialise à la requête principale (important)
wp_reset_postdata();
	
//FIN DE L'ENCADRÉ EN CE MOMENT			
			
			
			
			
			
	
			
			
// L'ENCADRÉ NOUVEAU
// 1. on définit ce que l'on veut
$args = array(
    'post_type' => 'post',
	'category_name' => 'nouveau',
    'posts_per_page' => 1,
);

// 2. on exécute la query
$my_query = new WP_Query($args);

// 3. on lance la boucle !
if($my_query->have_posts()) : while ($my_query->have_posts() ) : $my_query->the_post();


    echo '<a href="';
	the_permalink();
	echo '"><div id="nouveau-blog"><div class="image-encadre" style="background-image: url(';
	
	the_post_thumbnail_url( $medium );
	
	echo');">';

    echo '</div><!-- ferme image-encadre -->';
    echo '<div class="contenant-texte-encadre"><h2 class="surtitre-encadre">Nouveau sur <br>notre BLOG';
    echo '<h3 class="titre-encadre">';
    the_title();
    echo '</h3>';
    the_excerpt();
	echo '</div><!--Ferme contenant-texte-encadre--></div><!--ferme #nouveau-blog--></a>';
   

endwhile;
endif;

// 4. On réinitialise à la requête principale (important)
wp_reset_postdata();

//FIN DE L'ENCADRÉ NOUVEAU
		}
// FIN DE LA FONCTION cavasso_bandeau_cheval

/* Ajout de l'encadré Passion accroché au hook*/

add_action( 'homepage', 'cavasso_cadre_passion',      60 ); 
	    function cavasso_cadre_passion() {    
             echo '<div id="cadre-passion"><h2>Cavasso, la passion de la mer et des chevaux</h2><div id="texte-passion"><p>Cavasso, ce sont des soins à base d’algues marines.<br>En exploitant les richesses de la mer, Cavasso a développé une gamme complète pour apporter soin et confort aux chevaux au quotidien.</p></div><div id="jelis"><a href="cavasso/qui-sommes-nous/"><img src="/wp-content/design/picto-jelis-txt.png"></a></div><div id="jeregarde"><a href="/blog/nos-conseils-en-video/"><img src="/wp-content/design/picto-jeregarde-txt.png"></a></div></div>';
}	
add_action( 'homepage', 'cavasso_cadre_temoignage',      70 ); 
	    function cavasso_cadre_temoignage() {    
             echo '<div id="cadre-temoignage"><a href="/cavasso/ils-en-parlent/"><img src="/wp-content/design/temoignages.jpg"></a></div>';
}	
add_action( 'homepage', 'cavasso_cadre_conseils',      70 ); 
	    function cavasso_cadre_conseils() {    
             echo '<div id="cadre-conseils"><a href="/blog/nos-conseils-en-video/"><img src="/wp-content/design/conseils-cavasso.jpg"></a></div>';
}	


/* Ajoute un champ "genre" au profil utilisateur */
add_action( 'show_user_profile', 'custom_user_fields' );
add_action( 'edit_user_profile', 'custom_user_fields' );
add_action( "user_new_form", "custom_user_fields" );
function custom_user_fields( $user ) 
{
	$user_gender = get_the_author_meta( 'user_gender', $user->ID);
?>
	<h3><?php _e("Custom User information", "blank"); ?></h3>
	<table class="form-table">
    <tr>
        <th>
            <label for="user_gender"><?php _e("Genre"); ?></label>
        </th>
        <td>
            <select name="user_gender" id="user_gender" style="width:180px">
            	<option value="">-Sélectionner le genre-</option>
                <option value="male"   <?php selected( $user_gender, "Monsieur"); ?>>Monsieur</option>
                <option value="female" <?php selected( $user_gender, "Madame"); ?>>Madame</option>
            </select>
        </td>
    </tr>
</table>
<?php 
}
add_action( 'personal_options_update', 'save_custom_user_fields' );
add_action( 'edit_user_profile_update', 'save_custom_user_fields' );
add_action( 'user_register', 'save_custom_user_fields' );
function save_custom_user_fields( $user_id ) 
{
	if ( !current_user_can( 'edit_user', $user_id ) ) { return false; }
	update_user_meta( $user_id, 'user_gender', $_POST['user_gender'] );
}
/* FIN d'Ajoute un champ "genre" au profil utilisateur */


	
	

/* AJOUTE UN STATUT EN COURS DE LIVRAISON A LA GESTION DES COMMANDES */
/*
 * On ajoute un nouveau statut de post &quot;en cours de livraison&quot; dans WordPress
 */
function msk_create_being_delivered_status_in_wc() {
	register_post_status(
		'wc-being-delivered',
		array(
			'label' => __('Being delivered', 'uno'),
			'public'                    => true,
			'exclude_from_search'       => false,
			'show_in_admin_all_list'    => true,
			'show_in_admin_status_list' => true,
			'label_count'               => _n_noop('Being delivered <span class="count">(%s)</span>', 'Being delivered <span class="count">(%s)</span>', 'uno')
		)
	);
}
add_action( 'init', 'msk_create_being_delivered_status_in_wc' );


/*
 * On insère ce nouveau statut dans la liste des statuts utilisés par WooCommerce
 */
function msk_add_being_delivered_status_to_wc($order_statuses) {
	$new_statuses_array = array();

	foreach ($order_statuses as $key => $status) {
		$new_statuses_array[$key] = $status;
		if ('wc-processing' === $key) $new_statuses_array['wc-being-delivered'] = __('Being delivered', 'uno');
	}

	return $new_statuses_array;
}
add_filter('wc_order_statuses', 'msk_add_being_delivered_status_to_wc');



function msk_add_wc_custom_css_on_orders_list_page() {
	global $post_type;

	if (($_GET['post_type'] == 'shop_order') || ($post_type == 'shop_order')) :
		echo '<style>.widefat .column-order_status mark.being-delivered:after { font-family: WooCommerce; speak: none; font-weight: 400; font-variant: normal; text-transform: none; line-height: 1; -webkit-font-smoothing: antialiased; margin: 0; text-indent: 0; position: absolute; top: 0; left: 0; width: 100%; height: 100%; text-align: center; }';
		echo '.widefat .column-order_status mark.being-delivered:after { content: "\e019"; color: #4e9ed7; }</style>';
	endif;
}
add_action('admin_head', 'msk_add_wc_custom_css_on_orders_list_page');

/* FIN D'AJOUTE UN STATUT EN COURS DE LIVRAISON A LA GESTION DES COMMANDES */



/* AJOUTE UN STATUT Paiement accepte-é A LA GESTION DES COMMANDES */
/*
 * On ajoute un nouveau statut de post &quot;Paiment accepté&quot; dans WordPress
 */
function msk_create_paiement_accepte_status_in_wc() {
	register_post_status(
		'wc-paiement-accepte',
		array(
			'label' => __('Paiement accepte', 'uno'),
			'public'                    => true,
			'exclude_from_search'       => false,
			'show_in_admin_all_list'    => true,
			'show_in_admin_status_list' => true,
			'label_count'               => _n_noop('Paiement accepte <span class="count">(%s)</span>', 'Paiement accepte <span class="count">(%s)</span>', 'uno')
		)
	);
}
add_action( 'init', 'msk_create_paiement_accepte_status_in_wc' );


/*
 * On insère ce nouveau statut dans la liste des statuts utilisés par WooCommerce
 */
function msk_add_paiement_accepte_status_to_wc($order_statuses) {
	$new_statuses_array = array();

	foreach ($order_statuses as $key => $status) {
		$new_statuses_array[$key] = $status;
		if ('wc-processing' === $key) $new_statuses_array['wc-paiement-accepte'] = __('Paiement accepte', 'uno');
	}

	return $new_statuses_array;
}
add_filter('wc_order_statuses', 'msk_add_paiement_accepte_status_to_wc');


/**
 * Change the strength requirement on the woocommerce password
 *
 * Strength Settings
 * 4 = Strong
 * 3 = Medium (default) 
 * 2 = Also Weak but a little stronger 
 * 1 = Password should be at least Weak
 * 0 = Very Weak / Anything
 */
add_filter( 'woocommerce_min_password_strength', 'misha_change_password_strength' );
 
function misha_change_password_strength( $strength ) {
	 return 2;
}

