<?php
/**
 * Plugin Name: 	WooCommerce Checkout Field Editor Pro
 * Plugin URI:  	https://www.themehigh.com/product/woocommerce-checkout-field-editor-pro/
 * Description: 	Design woocommerce checkout form in your own way, customize checkout fields(Add, Edit, Delete and re arrange fields).
 * Version:     	2.9.3
 * Author:      	ThemeHiGH
 * Author URI:  	https://www.themehigh.com
 *
 * Text Domain: 	woocommerce-checkout-field-editor-pro
 * Domain Path: 	/languages
 *
 * WC requires at least: 3.0.0
 * WC tested up to: 3.3.0
 */
 
if(!defined('WPINC')){	die; }

if (!function_exists('is_woocommerce_active')){
	function is_woocommerce_active(){
	    $active_plugins = (array) get_option('active_plugins', array());
	    if(is_multisite()){
		   $active_plugins = array_merge($active_plugins, get_site_option('active_sitewide_plugins', array()));
	    }
	    
	    if(in_array('woocommerce/woocommerce.php', $active_plugins) || array_key_exists('woocommerce/woocommerce.php', $active_plugins) || class_exists('WooCommerce')){
	        return true;
	    }else{
	        return false;
	    }
	}
}

if(is_woocommerce_active()) {
	if(!class_exists('WCFE_Checkout_Field_Editor')){	
		class WCFE_Checkout_Field_Editor {	
			public function __construct(){
				$this->init_constants();
				$this->init_auto_updater();
				$this->plugin_activation();
				add_action('init', array($this, 'init'));
			}
			
			private function init_constants(){
				define('TH_WCFE_VERSION', '2.9.3');
				!defined('TH_WCFE_SOFTWARE_TITLE') && define('TH_WCFE_SOFTWARE_TITLE', 'WooCommerce Checkout Field Editor Pro');
				!defined('TH_WCFE_FILE_') && define('TH_WCFE_FILE_', __FILE__);
				!defined('TH_WCFE_PATH') && define('TH_WCFE_PATH', plugin_dir_path( __FILE__ ));
				!defined('TH_WCFE_URL') && define('TH_WCFE_URL', plugins_url( '/', __FILE__ ));
				!defined('TH_WCFE_ASSETS_URL') && define('TH_WCFE_ASSETS_URL', TH_WCFE_URL . 'assets/');
				
				!defined('THWCFE_BASE_NAME') && define('THWCFE_BASE_NAME', plugin_basename( __FILE__ ));
				!defined('THWCFE_PATH') && define('THWCFE_PATH', plugin_dir_path( __FILE__ ));
			}
			
			private function init_auto_updater(){
				if (!class_exists('WCFE_Auto_Update_License') ) {
					require_once( plugin_dir_path( __FILE__ ) . 'class-wcfe-auto-update-license.php' );
					$api_url = 'https://themehigh.com/';
					WCFE_Auto_Update_License::instance(__FILE__, TH_WCFE_SOFTWARE_TITLE, TH_WCFE_VERSION, 'plugin', $api_url, 'woocommerce-checkout-field-editor-pro');
				}
			}
			
			public function init() {
				//global $supress_field_modification;
				//$supress_field_modification = false;			
								
				$this->load_plugin_textdomain();
				
				!defined('TH_WEPE_WOO_ASSETS_URL') && define('TH_WEPE_WOO_ASSETS_URL', WC()->plugin_url() . '/assets/');
								
				//$this->include_required_classes();
				//$this->init_hooks();
				
				require_once( TH_WCFE_PATH . 'classes/class-wcfe-settings.php' );
				WCFE_Settings::instance();	
			}
			
			public function load_plugin_textdomain(){	
				$domain = 'woocommerce-checkout-field-editor-pro';
				$locale = apply_filters('plugin_locale', get_locale(), $domain);
				
				load_textdomain($domain, WP_LANG_DIR.'/woocommerce-checkout-field-editor-pro/'.$domain.'-'.$locale.'.mo');
				load_plugin_textdomain($domain, FALSE, dirname(plugin_basename( __FILE__ )) . '/languages/');
			}
			
			public function include_required_classes(){
				$required_classes = apply_filters('th_wcfe_require_class', array(
					'common' => array(
						'classes/class-wcfe-settings.php',
						'classes/fe/class-wcfe-checkout-field-editor-utils.php',
						'classes/fe/rules/class-wcfe-condition.php',
						'classes/fe/rules/class-wcfe-condition-set.php',
						'classes/fe/rules/class-wcfe-rule.php',
						'classes/fe/rules/class-wcfe-rule-set.php',
						'classes/fe/class-wcfe-section.php',
						'classes/fe/fields/class-wcfe-field.php',
						'classes/fe/fields/class-wcfe-field-inputtext.php',
						'classes/fe/fields/class-wcfe-field-hidden.php',
						'classes/fe/fields/class-wcfe-field-password.php',
						'classes/fe/fields/class-wcfe-field-textarea.php',				
						'classes/fe/fields/class-wcfe-field-select.php',
						'classes/fe/fields/class-wcfe-field-multiselect.php',
						'classes/fe/fields/class-wcfe-field-radio.php',
						'classes/fe/fields/class-wcfe-field-checkbox.php',
						'classes/fe/fields/class-wcfe-field-checkboxgroup.php',
						'classes/fe/fields/class-wcfe-field-datepicker.php',
						'classes/fe/fields/class-wcfe-field-timepicker.php',
						'classes/fe/fields/class-wcfe-field-file.php',
						'classes/fe/fields/class-wcfe-field-heading.php',
						'classes/fe/fields/class-wcfe-field-label.php',
						'classes/fe/fields/class-wcfe-field-country.php',
						'classes/fe/fields/class-wcfe-field-email.php',
						'classes/fe/fields/class-wcfe-field-state.php',
						'classes/fe/fields/class-wcfe-field-city.php',
						'classes/fe/fields/class-wcfe-field-tel.php',
						'classes/fe/fields/class-wcfe-field-factory.php',
						'classes/fe/utils/class-wcfe-utils-common.php',
						'classes/fe/utils/class-wcfe-utils-field.php',
						'classes/fe/utils/class-wcfe-utils-section.php',
						'classes/fe/utils/class-wcfe-utils-condition.php',
					),
					'admin' => array(
						'classes/fe/class-wcfe-checkout-field-editor-utils-admin.php',
						'classes/includes/class-wcfe-install.php',
						'classes/class-wcfe-settings-page.php',
						'classes/class-wcfe-license-settings.php',
						'classes/fe/class-wcfe-checkout-field-editor-settings.php',
						'classes/fe/class-wcfe-checkout-field-editor-settings-advanced.php',
					),
					'frontend' => array(
						'classes/fe/class-wcfe-checkout-field-editor-frontend.php',
					),
				));
				
				$this->include_required( $required_classes );
			}
			
			protected function include_required( $required_classes ) {
				foreach($required_classes as $section => $classes ) {
					foreach( $classes as $class ){
						if('common' == $section  || ('frontend' == $section && !is_admin() || ( defined('DOING_AJAX') && DOING_AJAX) ) 
							|| ('admin' == $section && is_admin()) && file_exists( TH_WCFE_PATH . $class )){
							require_once( TH_WCFE_PATH . $class );
						}
					}
				}
				
				//WooCommerce CSV Export Support
				//if(class_exists('WC_Zapier') && class_exists('WC_Zapier_Trigger') && $this->get_global_settings('enable_wc_zapier_support') === 'yes'){
				if($this->get_global_settings('enable_csv_export_support') === 'yes'){
					require_once( TH_WCFE_PATH . 'classes/includes/class-wcfe-checkout-field-editor-export-handler.php' );
					new WCFE_Checkout_Fields_Export_Handler();
				}
				
				if($this->get_global_settings('enable_wcpdf_invoice_packing_slip_support') === 'yes'){
					require_once( TH_WCFE_PATH . 'classes/includes/class-wcfe-wc-pdf-invoices-packing-slips-handler.php' );
					new WCFE_WC_PDF_Invoices_Packing_Slips_Handler();
				}
				
				//WooCommerce API Support
				require_once( TH_WCFE_PATH . 'classes/includes/class-wcfe-wc-api-handler.php' );
				new WCFE_WC_API_Handler();
				
				include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
				
				//WooCommerce Zapier Support
				if(is_plugin_active('woocommerce-zapier/woocommerce-zapier.php') && $this->get_global_settings('enable_wc_zapier_support') === 'yes'){
					require_once( TH_WCFE_PATH . 'classes/includes/class-wcfe-wc-zapier-handler.php' );
					new WCFE_WC_Zapier_Handler();
				}
			}
			
			public function plugin_activation(){
				$this->include_required_classes();
				$this->init_hooks();
			}
									
			private function init_hooks() {
				if(is_admin()){
					$install = WCFE_Install::instance();
					//$install->install();
					register_activation_hook( __FILE__, array( $install, 'install' ) );
					//register_deactivation_hook( __FILE__, array( 'WCFE_Install', 'uninstall' ));
				}
			}
			
			/*public function plugin_activated(){
				$admin_utils = WCFE_Legacy_Support::instance();
				$admin_utils->init();
			}*/
			
			public function get_global_settings($key){
				$settings = get_option('thwcfe_advanced_settings');
				if(is_array($settings) && isset($settings[$key])){
					return $settings[$key];
				}
				return '';
			}
			
		}	
	}
	
	$thwcfepro = new WCFE_Checkout_Field_Editor();
	
	/**
	 * The core plugin class that is used to define internationalization,
	 * admin-specific hooks, and public-facing site hooks.
	 */
	require plugin_dir_path( __FILE__ ) . 'includes/class-thwcfe.php';
	
	/**
	 * Begins execution of the plugin.
	 */
	function run_thwcfe() {
		$plugin = new THWCFE();
		$plugin->run();
	}
	run_thwcfe();
}