<?php
/**
 * The common utility functionalities for the plugin.
 *
 * @link       https://themehigh.com
 * @since      2.9.0
 *
 * @package    woocommerce-checkout-field-editor-pro
 * @subpackage woocommerce-checkout-field-editor-pro/public
 */
if(!defined('WPINC')){	die; }

if(!class_exists('THWCFE_Utils')):

class THWCFE_Utils {
	const OPTION_KEY_CUSTOM_SECTIONS   = 'thwcfe_sections';
	const OPTION_KEY_SECTION_HOOK_MAP  = 'thwcfe_section_hook_map';
	const OPTION_KEY_ADVANCED_SETTINGS = 'thwcfe_advanced_settings';
	
	static $PATTERN = array(			
			'/d/', '/j/', '/l/', '/z/', '/S/', //day (day of the month, 3 letter name of the day, full name of the day, day of the year, )			
			'/F/', '/M/', '/n/', '/m/', //month (Month name full, Month name short, numeric month no leading zeros, numeric month leading zeros)			
			'/Y/', '/y/' //year (full numeric year, numeric year: 2 digit)
		);
		
	static $REPLACE = array(
			'dd','d','DD','o','',
			'MM','M','m','mm',
			'yy','y'
		);
		
	public static function get_default_address_fields(){
		return array('country', 'address_1', 'address_2', 'city', 'state', 'postcode');
	}
	
	public static function is_default_address_field($field_name){
		$default_address_fields = self::get_default_address_fields();
		if($field_name && in_array($field_name, $default_address_fields) ){
			return true;
		}
		return false;
	}
	
	public static function get_advanced_settings(){
		$settings = get_option(self::OPTION_KEY_ADVANCED_SETTINGS);
		return empty($settings) ? false : $settings;
	}
	
	public static function get_setting_value($settings, $key){
		if(is_array($settings) && isset($settings[$key])){
			return $settings[$key];
		}
		return '';
	}
	
	public static function get_settings($key){
		$settings = self::get_advanced_settings();
		if(is_array($settings) && isset($settings[$key])){
			return $settings[$key];
		}
		return '';
	}
	
	public static function get_section_hook_map(){
		$section_hook_map = get_option(self::OPTION_KEY_SECTION_HOOK_MAP);	
		$section_hook_map = is_array($section_hook_map) ? $section_hook_map : array();
		return $section_hook_map;
	}
	
	public static function get_custom_sections(){
		$sections = get_option(self::OPTION_KEY_CUSTOM_SECTIONS);
		return empty($sections) ? false : $sections;
	}
		
	public static function get_checkout_section($section_name){
	 	if(isset($section_name) && !empty($section_name)){	
			$sections = self::get_custom_sections();
			if(is_array($sections) && isset($sections[$section_name])){
				$section = $sections[$section_name];	
				if(WCFE_Section_Utils::is_valid_section($section)){
					return $section;
				} 
			}
		}
		return false;
	}
	
	public static function get_fieldset_all($section, $exclude_disabled = true){
		$fieldset = array();
		if(WCFE_Section_Utils::is_valid_section($section) && $section->get_property('enabled')){
			$fieldset = WCFE_Section_Utils::get_fieldset_all($section, $exclude_disabled);
		}
		return !empty($fieldset) ? $fieldset : false;
	}
	
	public static function get_fieldset($section, $cart = false, $ignore_conditions = false){
		$fieldset = array();
		if(WCFE_Section_Utils::is_valid_section($section) && $section->get_property('enabled')){
			if($ignore_conditions){
				$fieldset = WCFE_Section_Utils::get_fieldset_all($section);
			}else if(!$cart){
				$fieldset = WCFE_Section_Utils::get_fieldset($section, false, false, false);
			}else{
				$products   = $cart['products'];
				$categories = $cart['categories'];
				$variations = $cart['variations'];
		
				$fieldset = WCFE_Section_Utils::get_fieldset($section, $products, $categories, $variations);
			}
		}
		
		return !empty($fieldset) ? $fieldset : false;
	}
	
	//WMSC Support
	public static function thwmsc_hooked_sections($sections, $hook_name){
		$section_hook_map = self::get_section_hook_map();
		
		if(is_array($section_hook_map) && isset($section_hook_map[$hook_name])){
			$sections = $section_hook_map[$hook_name];
		}	
						
		return empty($sections) ? false : $sections;
	}
	
	
		
	//TODO check for any better approach.
	public static function get_product_categories($product){
		$categories = array();
		if($product->get_id()){
			$product_cat = wp_get_post_terms($product->get_id(), 'product_cat');
			if(is_array($product_cat)){
				foreach($product_cat as $category){
					$parent_cat = get_ancestors( $category->term_id, 'product_cat' ); 
					if(is_array($parent_cat)){
						foreach($parent_cat as $pcat_id){
							$pcat = get_term( $pcat_id, 'product_cat' );
							$categories[] = $pcat->slug;
						}
					}
					$categories[] = $category->slug;
				}
			}
		}
		return $categories;
	}
	
	public static function get_user_roles($user = false) {
		$user = $user ? new WP_User( $user ) : wp_get_current_user();
		
		if(!($user instanceof WP_User))
		   return false;
		   
		$roles = $user->roles;
		return $roles;
	}
	
	public static function delete_item_by_value($arr, $value){
		if(is_array($arr) && ($key = array_search($value, $arr)) !== false) {
			unset($arr[$key]);
		}
		return $arr;
	}
		
	public static function get_jquery_date_format($woo_date_format){				
		$woo_date_format = !empty($woo_date_format) ? $woo_date_format : wc_date_format();
		return preg_replace(self::$PATTERN, self::$REPLACE, $woo_date_format);	
	}
	
	public static function convert_cssclass_string($cssclass){
		if(!is_array($cssclass)){
			$cssclass = array_map('trim', explode(',', $cssclass));
		}
		
		if(is_array($cssclass)){
			$cssclass = implode(" ",$cssclass);
		}
		return $cssclass;
	}
	
	public static function convert_string_to_array($str, $separator = ','){
		if(!is_array($str)){
			$str = array_map('trim', explode($separator, $str));
		}
		return $str;
	}
	
	public static function is_subset_of($arr1, $arr2){
		if(is_array($arr1) && is_array($arr2)){
			foreach($arr2 as $value){
				if(!in_array($value, $arr1)){
					return false;
				}
			}
		}
		return true;
	}
	
	public static function is_blank($value) {
		return empty($value) && !is_numeric($value);
	}
	
	public static function get_value_from_query_string($query_string, $key) {
		$value = false;
		
		if(is_string($query_string) && is_string($key)){
			$data = urldecode($query_string);
			$params = is_string($data) ? explode("&", $data) : array();
			
			foreach($params as $param) {
				$param_data = is_string($param) ? explode("=", $param) : array();
				
				if(isset($param_data[0]) && $param_data[0] === $key){
					$value = isset($param_data[1]) ? $param_data[1] : '';
				}
			}
		}
		return $value;
	}
	
	public static function sort_sections(&$sections){
		if(is_array($sections) && !empty($sections)){
			self::stable_uasort($sections, array('THWCFE_Utils', 'sort_sections_by_order'));
		}
		return $sections;
	}
	
	public static function sort_sections_by_order($a, $b){
		if(WCFE_Section_Utils::is_valid_section($a) && WCFE_Section_Utils::is_valid_section($b)){
			$order_a = is_numeric($a->get_property('order')) ? $a->get_property('order') : 0;
			$order_b = is_numeric($b->get_property('order')) ? $b->get_property('order') : 0;
			
			if($order_a == $order_b){
				return 0;
			}
			return ($order_a < $order_b) ? -1 : 1;
		}else{
			return 0;
		}
	}
	
	public static function stable_uasort(&$array, $cmp_function) {
		if(count($array) < 2) {
			return;
		}
		
		$halfway = count($array) / 2;
		$array1 = array_slice($array, 0, $halfway, TRUE);
		$array2 = array_slice($array, $halfway, NULL, TRUE);
	
		self::stable_uasort($array1, $cmp_function);
		self::stable_uasort($array2, $cmp_function);
		if(call_user_func_array($cmp_function, array(end($array1), reset($array2))) < 1) {
			$array = $array1 + $array2;
			return;
		}
		
		$array = array();
		reset($array1);
		reset($array2);
		while(current($array1) && current($array2)) {
			if(call_user_func_array($cmp_function, array(current($array1), current($array2))) < 1) {
				$array[key($array1)] = current($array1);
				next($array1);
			} else {
				$array[key($array2)] = current($array2);
				next($array2);
			}
		}
		while(current($array1)) {
			$array[key($array1)] = current($array1);
			next($array1);
		}
		while(current($array2)) {
			$array[key($array2)] = current($array2);
			next($array2);
		}
		return;
	}
	
	public static function is_wpml_active(){
		return function_exists('icl_object_id');
	}
	
	public static function woo_version_check( $version = '3.0' ) {
	  	if(function_exists( 'is_woocommerce_active' ) && is_woocommerce_active() ) {
			global $woocommerce;
			if( version_compare( $woocommerce->version, $version, ">=" ) ) {
		  		return true;
			}
	  	}
	  	return false;
	}
}

endif;