<?php
/**
 * The file that defines the core plugin class.
 *
 * @link       https://themehigh.com
 * @since      2.9.0
 *
 * @package    woocommerce-checkout-field-editor-pro
 * @subpackage woocommerce-checkout-field-editor-pro/includes
 */
if(!defined('WPINC')){	die; }

if(!class_exists('THWCFE')):

class THWCFE {
	/**
	 * The loader that's responsible for maintaining and registering all hooks that power
	 * the plugin.
	 *
	 * @since    2.9.0
	 * @access   protected
	 * @var      THWCFE_Loader    $loader    Maintains and registers all hooks for the plugin.
	 */
	protected $loader;

	/**
	 * The unique identifier of this plugin.
	 *
	 * @since    2.9.0
	 * @access   protected
	 * @var      string    $plugin_name    The string used to uniquely identify this plugin.
	 */
	protected $plugin_name;

	/**
	 * The current version of the plugin.
	 *
	 * @since    2.9.0
	 * @access   protected
	 * @var      string    $version    The current version of the plugin.
	 */
	protected $version;
	
	/**
	 * Define the core functionality of the plugin.
	 *
	 * Set the plugin name and the plugin version that can be used throughout the plugin.
	 * Load the dependencies, define the locale, and set the hooks for the admin area and
	 * the public-facing side of the site.
	 *
	 * @since    2.9.0
	 */
	public function __construct() {
		if(defined( 'TH_WCFE_VERSION')){
			$this->version = TH_WCFE_VERSION;
		} else {
			$this->version = '1.0.0';
		}
		$this->plugin_name = 'woocommerce-checkout-field-editor-pro';
		
		$this->load_dependencies();
		$this->set_locale();
		$this->define_admin_hooks();
		$this->define_public_hooks();
		
		$this->loader->add_action( 'init', $this, 'init' );
		//WMSC Support
		$this->loader->add_filter('thwmsc_hooked_sections', 'THWCFE_Utils', 'thwmsc_hooked_sections', 10, 2);
	}
	
	public function init(){
		$this->define_constants();
	}
	
	private function define_constants(){
		!defined('THWCFE_ASSETS_URL_ADMIN') && define('THWCFE_ASSETS_URL_ADMIN', TH_WCFE_URL . 'admin/assets/');
		!defined('THWCFE_ASSETS_URL_PUBLIC') && define('THWCFE_ASSETS_URL_PUBLIC', TH_WCFE_URL . 'public/assets/');
		!defined('THWCFE_WOO_ASSETS_URL') && define('THWCFE_WOO_ASSETS_URL', WC()->plugin_url() . '/assets/');
	}

	/**
	 * Load the required dependencies for this plugin.
	 *
	 * Include the following files that make up the plugin:
	 *
	 * - THWCFE_Loader. Orchestrates the hooks of the plugin.
	 * - THWCFE_i18n. Defines internationalization functionality.
	 * - THWCFE_Admin. Defines all hooks for the admin area.
	 * - THWCFE_Public. Defines all hooks for the public side of the site.
	 *
	 * Create an instance of the loader which will be used to register the hooks
	 * with WordPress.
	 *
	 * @since    2.9.0
	 * @access   private
	 */
	private function load_dependencies() {
		if(!function_exists('is_plugin_active')){
			include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
		}
		
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/class-thwcfe-autoloader.php';

		/**
		 * The class responsible for orchestrating the actions and filters of the
		 * core plugin.
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/class-thwcfe-loader.php';

		/**
		 * The class responsible for defining internationalization functionality
		 * of the plugin.
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/class-thwcfe-i18n.php';

		/**
		 * The class responsible for defining all actions that occur in the admin area.
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'admin/class-thwcfe-admin.php';

		/**
		 * The class responsible for defining all actions that occur in the public-facing
		 * side of the site.
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'public/class-thwcfe-public-checkout.php';
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'public/class-thwcfe-public-myaccount.php';

		$this->loader = new THWCFE_Loader();
	}

	/**
	 * Define the locale for this plugin for internationalization.
	 *
	 * Uses the THWCFE_i18n class in order to set the domain and to register the hook
	 * with WordPress.
	 *
	 * @since    2.9.0
	 * @access   private
	 */
	private function set_locale() {
		$plugin_i18n = new THWCFE_i18n($this->get_plugin_name());
		$this->loader->add_action( 'plugins_loaded', $plugin_i18n, 'load_plugin_textdomain' );
	}
	
	/*private function init_auto_updater(){
		if(!class_exists('THWCFE_Auto_Update_License') ) {
			$api_url = 'https://themehigh.com/';
			require_once plugin_dir_path( dirname( __FILE__ ) ) . 'class-thwcfe-auto-update-license.php';
			THWCFE_Auto_Update_License::instance(__FILE__, THWCFE_SOFTWARE_TITLE, THWCFE_VERSION, 'plugin', $api_url, THWCFE_i18n::TEXT_DOMAIN);
		}
	}*/
	
	/**
	 * Register all of the hooks related to the admin area functionality
	 * of the plugin.
	 *
	 * @since    2.9.0
	 * @access   private
	 */
	private function define_admin_hooks() {
		/*$plugin_admin = new THWCFE_Admin( $this->get_plugin_name(), $this->get_version() );

		$this->loader->add_action( 'admin_enqueue_scripts', $plugin_admin, 'enqueue_styles_and_scripts' );
		$this->loader->add_action( 'admin_menu', $plugin_admin, 'admin_menu' );
		$this->loader->add_filter( 'woocommerce_screen_ids', $plugin_admin, 'add_screen_id' );*/
	}

	/**
	 * Register all of the hooks related to the public-facing functionality
	 * of the plugin.
	 *
	 * @since    2.9.0
	 * @access   private
	 */
	private function define_public_hooks() {
		//$plugin_checkout = new THWCFE_Public_Checkout( $this->get_plugin_name(), $this->get_version() );
		//$this->loader->add_action( 'wp_enqueue_scripts', $plugin_checkout, 'enqueue_styles_and_scripts' );
		
		$plugin_myaccount = new THWCFE_Public_MyAccount( $this->get_plugin_name(), $this->get_version() );
		$this->loader->add_action( 'wp_enqueue_scripts', $plugin_myaccount, 'enqueue_styles_and_scripts' );
	}

	/**
	 * Run the loader to execute all of the hooks with WordPress.
	 *
	 * @since    2.9.0
	 */
	public function run() {
		$this->loader->run();
	}

	/**
	 * The name of the plugin used to uniquely identify it within the context of
	 * WordPress and to define internationalization functionality.
	 *
	 * @since     2.9.0
	 * @return    string    The name of the plugin.
	 */
	public function get_plugin_name() {
		return $this->plugin_name;
	}

	/**
	 * The reference to the class that orchestrates the hooks with the plugin.
	 *
	 * @since     2.9.0
	 * @return    THWCFE_Loader    Orchestrates the hooks of the plugin.
	 */
	public function get_loader() {
		return $this->loader;
	}

	/**
	 * Retrieve the version number of the plugin.
	 *
	 * @since     2.9.0
	 * @return    string    The version number of the plugin.
	 */
	public function get_version() {
		return $this->version;
	}
}

endif;