<?php
/**
 * Checkout Field Editor Export Handler
 *
 * @author      ThemeHiGH
 * @category    Admin
 */
 
if(!defined('ABSPATH')){ exit; }
 
if(!class_exists('WCFE_Checkout_Fields_Export_Handler')):
 
class WCFE_Checkout_Fields_Export_Handler extends WCFE_Checkout_Fields_Utils {
	private $fields;

	public function __construct() {
		$this->fields = $this->get_export_fields();

		// Customer / Order CSV Export column headers/data
		add_filter( 'wc_customer_order_csv_export_order_headers', array( $this, 'thwcfe_order_csv_export_order_headers' ), 10, 2 );
		add_filter( 'wc_customer_order_csv_export_order_row', array( $this, 'thwcfe_customer_order_csv_export_order_row' ), 10, 4 );
	}

	/**
	 * Adds support for Customer/Order CSV Export by adding a vendor column header
	 */
	public function thwcfe_order_csv_export_order_headers($headers, $csv_generator) {
		$field_headers = array();

		foreach ( $this->fields as $name => $options ) {
			$field_headers[ $name ] = $options['title'];
		}

		return array_merge( $headers, $field_headers );
	}

	/**
	 * Adds support for Customer/Order CSV Export by adding checkout editor field data
	 */
	public function thwcfe_customer_order_csv_export_order_row( $order_data, $order, $csv_generator ) {
		$field_data = array();
		
		$order_id = false;
		if($this->woo_version_check()){
			$order_id = $order->get_id();
		}else{
			$order_id = $order->id;
		}

		foreach ( $this->fields as $name => $options ) {
			$field_data[ $name ] = get_post_meta( $order_id, $name, true );
		}

		$new_order_data = array();

		if(isset($csv_generator->export_format) && ($csv_generator->export_format == 'default_one_row_per_item' || $csv_generator->export_format == 'legacy_one_row_per_item')){
			foreach($order_data as $data){
				$new_order_data[] = array_merge( $field_data, (array) $data );
			}
		} else if(apply_filters('thwcfe_order_csv_export_one_row_per_item', false)){
			foreach($order_data as $data){
				$new_order_data[] = array_merge( $field_data, (array) $data );
			}
		} else {
			$new_order_data = array_merge( $field_data, $order_data );
		}

		return $new_order_data;
	}

	/**
	 * Get all checkout fields
	 */
	private function get_fields() {
		/*$fields = array();

		$billing_fields = $this->get_checkout_fields('billing');
		if($billing_fields !== false){
			$fields = array_merge( $fields, $billing_fields );
		}

		$shipping_fields = $this->get_checkout_fields('shipping');
		if($shipping_fields !== false){
			$fields = array_merge( $fields, $shipping_fields );
		}

		$additional_fields = $this->get_checkout_fields('additional');
		if($additional_fields !== false){
			$fields = array_merge( $fields, $additional_fields );
		}*/
		$fields = $this->get_export_fields();
		return $fields;
	}
	
	public function get_export_fields(){
		$fields = array();
		$export_fields_str = $this->get_settings('csv_export_columns');
		
		if(!empty($export_fields_str)){
			$export_fields_arr = explode(",", $export_fields_str);
			
			if(is_array($export_fields_arr) && !empty($export_fields_arr)){
				$sections = $this->get_checkout_sections();	
				
				if($sections){
					foreach($sections as $sname => $section){	
						$temp_fields = WCFE_Section_Utils::get_fields($section);
						if($temp_fields && is_array($temp_fields)){
							foreach($temp_fields as $key => $field){
								if(WCFE_Field_Utils::is_custom_field($field) && WCFE_Field_Utils::is_enabled($field) && in_array($key, $export_fields_arr)){
									$exp_field = array();
									$exp_field['name'] = $field->get_property('name');
									$exp_field['title'] = $field->get_property('title');
									$exp_field['order_meta'] = $field->get_property('order_meta');
									$exp_field['user_meta'] = $field->get_property('user_meta');
									
									$fields[$key] = $exp_field;
								}
							}
						}
					}
				}
			}
		}
		return $fields;
	}
}

endif;
new WCFE_Checkout_Fields_Export_Handler();