<?php
/**
 * Checkout Section Utils
 *
 * @author    ThemeHiGH
 * @category  Admin
 */

if(!defined('ABSPATH')){ exit; }

if(!class_exists('WCFE_Section_Utils')):

class WCFE_Section_Utils{
	static $DEFAULT_SECTIONS = array('billing', 'shipping', 'additional');
	static $SECTION_PROPS = array(
		'name' 	   => array('name'=>'name', 'value'=>''),		
		'position' => array('name'=>'position', 'value'=>''),
		'order'    => array('name'=>'order', 'value'=>''),
		'cssclass' => array('name'=>'cssclass', 'value'=>array(), 'value_type'=>'array'),
		
		'show_title'     => array('name'=>'show_title', 'value'=>1, 'value_type'=>'boolean'),
		'show_title_my_account' => array('name'=>'show_title_my_account', 'value'=>1, 'value_type'=>'boolean'),
		'custom_section' => array('name'=>'custom_section', 'value'=>1, 'value_type'=>'boolean'),
		
		'title' 	  => array('name'=>'title', 'value'=>''),
		'title_type'  => array('name'=>'title_type', 'value'=>''),
		'title_color' => array('name'=>'title_color', 'value'=>''),
		'title_class' => array('name'=>'title_class', 'value'=>array(), 'value_type'=>'array'),
		
		'subtitle' 		 => array('name'=>'subtitle', 'value'=>''),
		'subtitle_type'  => array('name'=>'subtitle_type', 'value'=>''),
		'subtitle_color' => array('name'=>'subtitle_color', 'value'=>''),
		'subtitle_class' => array('name'=>'subtitle_class', 'value'=>array(), 'value_type'=>'array'),
	);
	
	public static function is_valid_section($section){
		if(isset($section) && $section instanceof WCFE_Checkout_Section && !empty($section->name)){
			return true;
		} 
		return false;
	}
	
	public static function is_enabled($section){
		if($section->get_property('enabled')){
			return true;
		}
		return false;
	}
	
	public static function is_custom_section($section){
		return $section->custom_section;
	}
	
	public static function has_user_fields($section, $fieldset=false){
		$has_user_fields = false;
		if(is_array($fieldset)){
			foreach($fieldset as $key => $field) {
				if(isset($field['custom']) && $field['custom']){
					$ftype = isset($field['type']) ? $field['type'] : 'text';
						
					if(isset($field['user_meta']) && $field['user_meta']){
						$has_user_fields = true;
					}else if(($ftype === 'label' || $ftype === 'heading') && (isset($field['show_in_my_account_page']) && $field['show_in_my_account_page'])){
						$has_user_fields = true;
					}
				}
			}
		}
		return $has_user_fields;
	}
	
	public static function get_property_set($section, $esc_attr=false){
		if(self::is_valid_section($section)){
			$props_set = array();
			
			foreach(self::$SECTION_PROPS as $pname => $props){
				$pvalue = $section->get_property($props['name']);
				
				if(isset($props['value_type']) && $props['value_type'] === 'array' && !empty($pvalue)){
					$pvalue = is_array($pvalue) ? $pvalue : explode(',', $pvalue);
				}
				
				if(isset($props['value_type']) && $props['value_type'] != 'boolean'){
					$pvalue = empty($pvalue) ? $props['value'] : $pvalue;
				}
				
				$pvalue = $esc_attr && is_string($pvalue) ? esc_attr($pvalue) : $pvalue;
				$props_set[$pname] = $pvalue;
			}
			
			$props_set['custom'] = self::is_custom_section($section);
			
			return $props_set;
		}else{
			return false;
		}
	}
	
	public static function get_property_json($section){
		$props_json = '';
		$props_set = self::get_property_set($section, true);
		
		if($props_set){
			$props_json = json_encode($props_set);
		}
		return $props_json;
	}
	
	public static function add_field($section, $field){
		if(self::is_valid_section($section) && WCFE_Field_Utils::is_valid_field($field)){
			$size = sizeof($section->fields);
			$field->set_property('order', $size);
			$field->set_property('custom_field', 1);
			$section->fields[$field->get_property('name')] = $field;
			return $section;
		}else{
			throw new Exception('Invalid Section or Field Object.');
		}
	}
	
	public static function update_field($section, $field){
		if(self::is_valid_section($section) && WCFE_Field_Utils::is_valid_field($field)){
			$name = $field->get_property('name');
			$field_set = $section->fields;
			
			if(!empty($name) && is_array($field_set) && isset($field_set[$name])){
				$o_field = $field_set[$name];				
				$index = array_search($name, array_keys($field_set));
				$field->set_property('order', $index);
				$field->set_property('custom_field', $o_field->get_property('custom_field'));
				$section->fields[$name] = $field;
			}
			return $section;
		}else{
			throw new Exception('Invalid Section or Field Object.');
		}
	}
	
	public static function get_fields($section){
		return (is_array($section->fields) && !empty($section->fields)) ? $section->fields : array();
	}
	
	public static function clear_fields($section){
		if(self::is_valid_section($section)){
			$section->fields = array();
		}
		return $section;
	}
	
	public static function get_fieldset_all($section, $exclude_disabled = true){
		$fieldset = array();
		if(self::is_valid_section($section)){
			if(is_array($section->fields) && !empty($section->fields)){
				foreach($section->fields as $name => $field){
					if(WCFE_Field_Utils::is_valid_field($field)){
						if($exclude_disabled){
							if(WCFE_Field_Utils::is_enabled($field)){
								$field_props = WCFE_Field_Utils::get_property_set($field);
								$fieldset[$name] = $field_props; 
							}
						}else{
							$field_props = WCFE_Field_Utils::get_property_set($field);
							$fieldset[$name] = $field_props;
						}
					} 
				}
			}
		}
		return $fieldset;
	}
	
	public static function get_fieldset($section, $products, $categories, $product_variations=false){
		$fieldset = array();
		if(is_array($section->fields) && !empty($section->fields)){
			foreach($section->fields as $name => $field){
				if(WCFE_Field_Utils::is_valid_field($field)){
					if(WCFE_Field_Utils::is_enabled($field)){
						if(WCFE_Field_Utils::show_field($field, $products, $categories, $product_variations)){
							$field_props = WCFE_Field_Utils::get_property_set($field);
							$fieldset[$name] = $field_props; 
						}
					}
				} 
			}
		}
		return $fieldset;
	}
	
	public static function get_user_fields_full(){
		$user_fields = array();
		
		$sections = WCFE_Checkout_Fields_Utils::get_checkout_sections();	
		foreach($sections as $sname => $section){	
			$fields = WCFE_Section_Utils::get_fields($section);
			if($fields && is_array($fields)){
				foreach($fields as $key => $field){
					if(WCFE_Field_Utils::is_custom_field($field) && WCFE_Field_Utils::is_enabled($field) && WCFE_Field_Utils::is_user_field($field)){
						$user_fields[$key] = $field;
					}
				}
			}
		}
		
		return $user_fields;
	}
	
	public static function prepare_section_from_posted_data($posted, $form = 'new'){
		$name     = isset($posted['i_name']) ? $posted['i_name'] : '';
		$position = isset($posted['i_position']) ? $posted['i_position'] : '';
		$title    = isset($posted['i_title']) ? $posted['i_title'] : '';

		if(!$name || !$title || !$position){
			return;
		}
		
		if($form === 'edit'){
			$section = WCFE_Checkout_Fields_Utils::get_checkout_section($name);
		}else{
			$name = strtolower($name);
			$name = is_numeric($name) ? "s_".$name : $name;
				
			$section = new WCFE_Checkout_Section();
			$section->set_property('id', $name);
		}
		
		foreach( self::$SECTION_PROPS as $pname => $property ){
			$iname  = 'i_'.$pname;
			$pvalue = isset($posted[$iname]) ? $posted[$iname] : $property['value'];
			$pvalue = is_string($pvalue) ? trim(stripslashes($pvalue)) : $pvalue;
			
			if($pname === 'show_title' || $pname === 'show_title_my_account'){
				$pvalue = !empty($pvalue) && $pvalue === 'yes' ? 1 : 0;
			}
			
			$section->set_property($pname, $pvalue);
		}
		
		if($form != 'edit'){
			$name = urldecode( sanitize_title(wc_clean($name)) );
			$section->set_property('name', $name);
			$section->set_property('id', $name);
		}
		
		$section->set_property('custom_section', 1);
		
		//WPML Support
		self::add_wpml_support($section);
		return $section;
	}
	
	public static function get_title_html($section){
		$title_html = '';
		if($section->get_property('title')){
			$title_type  = $section->get_property('title_type') ? $section->get_property('title_type') : 'label';
			$title_style = $section->get_property('title_color') ? 'style="color:'.$section->get_property('title_color').';"' : '';
			$title = WCFE_Checkout_Fields_Utils::__wcfe($section->get_property('title'));
			
			$title_html .= '<'.$title_type.' class="'.$section->get_property('title_class').'" '.$title_style.'>'.$title.'</'.$title_type.'>';
		}
		
		$subtitle_html = '';
		if($section->get_property('subtitle')){
			$subtitle_type  = $section->get_property('subtitle_type') ? $section->get_property('subtitle_type') : 'span';
			$subtitle_style = $section->get_property('subtitle_color') ? 'style="color:'.$section->get_property('subtitle_color').';"' : '';
			$subtitle = WCFE_Checkout_Fields_Utils::__wcfe($section->get_property('subtitle'));
			
			$subtitle_html .= '<'.$subtitle_type.' class="'.$section->get_property('subtitle_class').'" '.$subtitle_style.'>'.$subtitle.'</'.$subtitle_type.'>';
		}
		
		$html = $title_html;
		if(!empty($subtitle_html)){
			$html .= $subtitle_html;
		}
		return $html;
	}
	
	public static function sort_fields($section){
		uasort($section->fields, array('self', 'sort_by_order'));
		return $section;
	}
	
	public static function sort_by_order($a, $b){
	    if($a->get_property('order') == $b->get_property('order')){
	        return 0;
	    }
	    return ($a->get_property('order') < $b->get_property('order')) ? -1 : 1;
	}
	
	public static function add_wpml_support($section){
		WCFE_Checkout_Fields_Utils::wcfe_wpml_register_string('Section Title - '.$section->name, $section->title );
		WCFE_Checkout_Fields_Utils::wcfe_wpml_register_string('Section Subtitle - '.$section->name, $section->subtitle );
	}
	
	
	
	












	/*public function get_section_properties(){
		return array(
			'name' 	   => array('name'=>'name', 'value'=>''),		
			'position' => array('name'=>'position', 'value'=>''),
			'order'    => array('name'=>'order', 'value'=>''),
			'cssclass' => array('name'=>'cssclass', 'value'=>array(), 'value_type'=>'array'),
			
			'show_title'     => array('name'=>'show_title', 'value'=>1, 'value_type'=>'boolean'),
			'custom_section' => array('name'=>'custom_section', 'value'=>1, 'value_type'=>'boolean'),
			
			'title' 	  => array('name'=>'title', 'value'=>''),
			'title_type'  => array('name'=>'title_type', 'value'=>''),
			'title_color' => array('name'=>'title_color', 'value'=>''),
			'title_class' => array('name'=>'title_class', 'value'=>array(), 'value_type'=>'array'),
			
			'subtitle' 		 => array('name'=>'subtitle', 'value'=>''),
			'subtitle_type'  => array('name'=>'subtitle_type', 'value'=>''),
			'subtitle_color' => array('name'=>'subtitle_color', 'value'=>''),
			'subtitle_class' => array('name'=>'subtitle_class', 'value'=>array(), 'value_type'=>'array'),
		);
	}
	
	public function populate_section($options){
		if(isset($options) && is_array($options)){
			$this->id    = isset($options['name']) ? $options['name'] : '';
			$this->name  = isset($options['name']) ? $options['name'] : '';
			$this->title = isset($options['title']) ? $options['title'] : '';		    
		}
	}*/
	
	/*public function add_wpml_support(){
		$this->wcfe_wpml_register_string('Section Title - '.$this->name, $this->title );
		$this->wcfe_wpml_register_string('Section Subtitle - '.$this->name, $this->subtitle );
	}*/
	
	/*public function clear_fields(){
		$this->fields = array();
	}*/
	
	/*public function add_field($field){
		if($field){
			$this->fields[$field->get_property('name')] = $field;
		}
	}*/
	
	/*public function set_fields($fields){
		$this->fields = $fields;
	}*/
	/*public function get_fields(){
		return (is_array($this->fields) && !empty($this->fields)) ? $this->fields : array();
	}*/
	
	/*public function get_fieldset($products, $categories){
		$fieldset = array();
		if(is_array($this->fields) && !empty($this->fields)){
			foreach($this->fields as $name => $field){
				if($this->is_valid_field($field)){
					if($field->get_property('enabled')){
						if($field->show_field($products, $categories)){
							//$field_props = $field->get_field_array();
							$field_props = $field->get_property_set();
							$fieldset[$name] = $field_props; 
						}
					}
				} 
			}
		}
		return $fieldset;
	}*/
	
	/*public function get_fieldset_all($exclude_disabled = true){
		$fieldset = array();
		if(is_array($this->fields) && !empty($this->fields)){
			foreach($this->fields as $name => $field){
				if($this->is_valid_field($field)){
					if($exclude_disabled){
						if($field->get_property('enabled')){
							$field_props = $field->get_property_set();
							$fieldset[$name] = $field_props; 
						}
					}else{
						$field_props = $field->get_property_set();
						$fieldset[$name] = $field_props;
					}
				} 
			}
		}
		return $fieldset;
	}*/
	
	/*public function is_valid_field($field){
		if(isset($field) && $field instanceof WCFE_Checkout_Field && $field->is_valid()){
			return true;
		} 
		return false;
	}*/

	/*public function get_title_html(){
		$title_html = '';
		if($this->get_title()){
			$title_type  = $this->get_title_type() ? $this->get_title_type() : 'label';
			$title_style = $this->get_title_color() ? 'style="color:'.$this->get_title_color().';"' : '';
			
			$title_html .= '<'.$title_type.' class="'.$this->get_title_class().'" '.$title_style.'>'.$this->__wcfe($this->get_title()).'</'.$title_type.'>';
		}
		
		$subtitle_html = '';
		if($this->get_subtitle()){
			$subtitle_type  = $this->get_subtitle_type() ? $this->get_subtitle_type() : 'span';
			$subtitle_style = $this->get_subtitle_color() ? 'style="color:'.$this->get_subtitle_color().';"' : '';
			
			$subtitle_html .= '<'.$subtitle_type.' class="'.$this->get_subtitle_class().'" '.$subtitle_style.'>'.$this->__wcfe($this->get_subtitle()).'</'.$subtitle_type.'>';
		}
		
		$html = $title_html;
		if(!empty($subtitle_html)){
			$html .= $subtitle_html;
		}
		return $html;
	}*/
	
	/*public function get_html(){
		$fields = $this->get_fields();
		$html = '';
		if($fields){
			$html .= '<table class="extra-options" cellspacing="0"><tbody>';
			
			if($this->is_show_title()){
				$html .= $this->get_title_html();
			}
			
			foreach($fields as $field){
				$html .= $field->get_html();
			}		
			$html .= '</tbody></table>';
		}
		
		return $html;
	}*/
	
	/*public function render_section(){		
		echo $this->get_html();
	}*/
	
	/*public function is_valid(){
		if(empty($this->name)){
			return false;
		}
		return true;
	}*/
	
	/*public function has_fields(){
		if($this->get_fields()){
			return true;
		}
		return false;
	}
	
	public function add_condition_set($condition_set){
		$this->condition_sets[] = $condition_set;
	}
	
	public function show_section($product, $categories){
		$show = true;
		if(!empty($this->condition_sets)){			
			foreach($this->condition_sets as $condition_set){
				if($condition_set->show_element()){
					$show = false;
				}
			}
		}
		return $show;
	}*/
	
	/*public function sort_fields(){
		uasort($this->fields, array($this, 'sort_by_order'));
	}
	
	public function sort_by_order($a, $b){
	    if($a->get_property('order') == $b->get_property('order')){
	        return 0;
	    }
	    return ($a->get_property('order') < $b->get_property('order')) ? -1 : 1;
	}*/
	
	/*public function get_property_array(){
		if($this->is_valid()){
			$section = array();
			$section_properties = $this->get_section_properties();
			
			foreach($section_properties as $pname => $props){
				$pvalue = $this->get_property($props['name']);
				
				if(isset($props['value_type']) && $props['value_type'] === 'array' && !empty($pvalue)){
					$pvalue = is_array($pvalue) ? $pvalue : explode(',', $pvalue);
				}
				
				if(isset($props['value_type']) && $props['value_type'] != 'boolean'){
					$pvalue = empty($pvalue) ? $props['value'] : $pvalue;
				}
				
				$section[$pname] = $pvalue;
			}
			
			$section['custom'] = $this->is_custom_section();
			
			return $section;
		}else{
			return false;
		}
	}
	
	public function get_property_json(){
		$props_json = '';
		$props_array = $this->get_property_array();
		
		if($props_array){
			$props_json = json_encode($props_array);
		}
		return $props_json;
	}*/
	
}

endif;