<?php
/**
 * WooCommerce Checkout Field Editor Pro - Settings
 *
 * @author      ThemeHiGH
 * @category    Admin
 */
 
if(!defined('ABSPATH')){ exit; }

if(!class_exists('WCFE_Settings')) :

class WCFE_Settings {
	protected static $_instance = null;	
	public $admin_instance = null;
	public $frontend_instance = null;
	
	/**
	 * Constructor
	 */
	public function __construct() {		
		add_action('admin_menu', array($this, 'admin_menu'));
		add_filter('woocommerce_screen_ids', array($this, 'add_screen_id'));
		add_filter('plugin_action_links_'.THWCFE_BASE_NAME, array($this, 'plugin_action_links'));
		add_filter('plugin_row_meta', array($this, 'plugin_row_meta'), 10, 2);
		
		$this->init();
	}
	
	public static function instance() {
		if(is_null(self::$_instance)){
			self::$_instance = new self();
		}
		return self::$_instance;
	}
	
	public function init() {		
		if(!is_admin() || (defined( 'DOING_AJAX' ) && DOING_AJAX)){
			$this->frontend_instance = new WCFE_Checkout_Field_Editor_Frontend();
		}else if(is_admin()){
			$admin_utils = WCFE_Checkout_Fields_Admin_Utils::instance();
			$admin_utils->init();
				
			$this->admin_instance = WCFE_Checkout_Field_Editor_Settings::instance();
		}		
	}
			
	public function admin_menu() {
		$this->screen_id = add_submenu_page('woocommerce', __('WooCommerce Checkout Field Editor Pro', 'woocommerce-checkout-field-editor-pro'), 
		__('Checkout Form', 'woocommerce-checkout-field-editor-pro'), 'manage_woocommerce', 'th_checkout_field_editor_pro', array($this, 'output_settings'));

		//add_action('admin_print_scripts-'. $this->screen_id, array($this, 'enqueue_admin_scripts'));
		add_action('admin_enqueue_scripts', array($this, 'enqueue_admin_scripts'));
	}

	public function add_screen_id($ids){
		$ids[] = 'woocommerce_page_th_checkout_field_editor_pro';
		$ids[] = strtolower(__('WooCommerce', 'woocommerce-checkout-field-editor-pro')) .'_page_th_checkout_field_editor_pro';

		return $ids;
	}
	
	public function plugin_action_links($links) {
		$settings_link = '<a href="'.admin_url('admin.php?page=th_checkout_field_editor_pro').'">'. __('Settings') .'</a>';
		array_unshift($links, $settings_link);
		return $links;
	}
	
	public function plugin_row_meta( $links, $file ) {
		if(THWCFE_BASE_NAME == $file) {
			$doc_link = esc_url('https://www.themehigh.com/help-guides/woocommerce-checkout-field-editor/');
			$support_link = esc_url('https://www.themehigh.com/help-guides/');
				
			$row_meta = array(
				'docs' => '<a href="'.$doc_link.'" target="_blank" aria-label="'.THWCFE_i18n::esc_attr__t('View plugin documentation').'">'.THWCFE_i18n::esc_html__t('Docs').'</a>',
				'support' => '<a href="'.$support_link.'" target="_blank" aria-label="'. THWCFE_i18n::esc_attr__t('Visit premium customer support' ) .'">'. THWCFE_i18n::esc_html__t('Premium support') .'</a>',
			);

			return array_merge( $links, $row_meta );
		}
		return (array) $links;
	}
	
	public function output_settings() {
		$tab  = isset( $_GET['tab'] ) ? esc_attr( $_GET['tab'] ) : 'fields';
		
		if($tab === 'advanced_settings'){			
			$advanced_settings = WCFE_Checkout_Field_Editor_Advanced_Settings::instance();	
			$advanced_settings->output_page();			
		}else if($tab === 'license_settings'){			
			$license_settings = WCFE_License_Settings::instance();	
			$license_settings->output_page();	
		}else{
			$admin_instance = WCFE_Checkout_Field_Editor_Settings::instance();	
			$admin_instance->output_page();	
		}
	}

	public function enqueue_admin_scripts($hook) {
		/*if('woocommerce_page_th_checkout_field_editor_pro' != $hook){
        	return;
    	}*/
		if(strpos($hook, 'page_th_checkout_field_editor_pro') === false) {
			return;
		}
		
		wp_enqueue_style('woocommerce_admin_styles');
		wp_enqueue_style('wp-color-picker');
		wp_enqueue_style('thwcfe-admin-style', plugins_url('/assets/css/thwcfe-checkout-field-editor-admin.css', dirname(__FILE__)), TH_WCFE_VERSION);
		
		//wp_register_script('thwcfe-select2', TH_WCFE_ASSETS_URL.'js/select2.min.js', array('jquery'));
		
		wp_enqueue_script('thwcfe-settings-base-script', plugins_url('/assets/js/thwcfe-settings-base.js', dirname(__FILE__)), 
		array('jquery', 'jquery-ui-dialog', 'jquery-ui-sortable', 'woocommerce_admin', 'select2', 'wp-color-picker', 'jquery-tiptip'), TH_WCFE_VERSION);
		wp_enqueue_script('thwcfe-admin-script', plugins_url('/assets/js/thwcfe-checkout-field-editor-admin.js', dirname(__FILE__)), 
		array('thwcfe-settings-base-script'), TH_WCFE_VERSION);
		wp_enqueue_script('thwcfe-settings-advanced-script', plugins_url('/assets/js/thwcfe-settings-advanced.js', dirname(__FILE__)), 
		array('thwcfe-settings-base-script'), TH_WCFE_VERSION);
	
        $wcfe_var = array(
            'admin_url' => admin_url(),
            'ajaxurl'   => admin_url( 'admin-ajax.php' ),
			'sanitize_names' => apply_filters("thwcfe_sanitize_field_names", true),
        );
		wp_localize_script('thwcfe-admin-script', 'wcfe_var', $wcfe_var);
	}	
}

endif;