<?php
/*********************************************************************************
 * WP Ultimate CSV Importer is a Tool for importing CSV for the Wordpress
 * plugin developed by Smackcoders. Copyright (C) 2016 Smackcoders.
 *
 * WP Ultimate CSV Importer is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Affero General Public License version 3
 * as published by the Free Software Foundation with the addition of the
 * following permission added to Section 15 as permitted in Section 7(a): FOR
 * ANY PART OF THE COVERED WORK IN WHICH THE COPYRIGHT IS OWNED BY WP Ultimate
 * CSV Importer, WP Ultimate CSV Importer DISCLAIMS THE WARRANTY OF NON
 * INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * WP Ultimate CSV Importer is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Affero General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA.
 *
 * You can contact Smackcoders at email address info@smackcoders.com.
 *
 * The interactive user interfaces in original and modified versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * WP Ultimate CSV Importer copyright notice. If the display of the logo is
 * not reasonably feasible for technical reasons, the Appropriate Legal
 * Notices must display the words
 * "Copyright Smackcoders. 2016. All rights reserved".
 ********************************************************************************/

if ( ! defined( 'ABSPATH' ) )
        exit; // Exit if accessed directly

class SmUCIUserHelper {

	public $def_mpCols = array('Shipping Email' => 'msi_email',
	                           'Shipping Name' => 'msi_name',
	                           'Shipping Address1' => 'msi_address1',
	                           'Shipping Address2' => 'msi_address2',
	                           'Shipping City' => 'msi_city',
	                           'Shipping State' => 'msi_state',
	                           'Shipping Zip' => 'msi_zip',
	                           'Shipping Country' => 'msi_country',
	                           'Shipping Phone' => 'msi_phone',
	                           'Billing Email' => 'mbi_email',
	                           'Billing Name' => 'mbi_name',
	                           'Billing Address1' => 'mbi_address1',
	                           'Billing Address2' => 'mbi_address2',
	                           'Billing City' => 'mbi_city',
	                           'Billing State' => 'mbi_state',
	                           'Billing Zip' => 'mbi_zip',
	                           'Billing Country' => 'mbi_country',
	                           'Billing Phone' => 'mbi_phone'
	);

	public $def_wcCols = array('Billing First Name' => 'billing_first_name',
	                           'Billing Last Name' => 'billing_last_name',
	                           'Billing Company' => 'billing_company',
	                           'Billing Address1' => 'billing_address_1',
	                           'Billing Address2' => 'billing_address_2',
	                           'Billing City' => 'billing_city',
	                           'Billing PostCode' => 'billing_postcode',
	                           'Billing State' => 'billing_state',
	                           'Billing Country' => 'billing_country',
	                           'Billing Phone' => 'billing_phone',
	                           'Billing Email' => 'billing_email',
	                           'Shipping First Name' => 'shipping_first_name',
	                           'Shipping Last Name' => 'shipping_last_name',
	                           'Shipping Company' => 'shipping_company',
	                           'Shipping Address1' => 'shipping_address_1',
	                           'Shipping Address2' => 'shipping_address_2',
	                           'Shipping City' => 'shipping_city',
	                           'Shipping PostCode' => 'shipping_postcode',
	                           'Shipping State' => 'shipping_state',
	                           'Shipping Country' => 'shipping_country',
	                           'API Consumer Key' => 'woocommerce_api_consumer_key',
	                           'API Consumer Secret' => 'woocommerce_api_consumer_secret',
	                           'API Key Permissions' => 'woocommerce_api_key_permissions',
	                           'Shipping Region' => '_wpsc_shipping_region' ,
	                           'Billing Region' => '_wpsc_billing_region',
	                           'Cart' => '_wpsc_cart'
	);

	public function billing_information_for_users () {
		$billing_and_shipping_info = array();
		if(in_array( 'marketpress/marketpress.php', $this->get_active_plugins() ) || in_array( 'wordpress-ecommerce/marketpress.php', $this->get_active_plugins() )) {
			foreach($this->def_mpCols as $mp_key => $mp_val) {
				$billing_and_shipping_info['BSI'][$mp_val]['label'] = $mp_key;
				$billing_and_shipping_info['BSI'][$mp_val]['name'] = $mp_val;
			}
		}
		if(in_array( 'woocommerce/woocommerce.php', $this->get_active_plugins() )) {
			foreach($this->def_wcCols as $woo_key => $woo_val) {
				$billing_and_shipping_info['BSI'][$woo_val]['label'] = $woo_key;
				$billing_and_shipping_info['BSI'][$woo_val]['name'] = $woo_val;
			}
		}
		return $billing_and_shipping_info;
	}

	public function get_active_plugins() {
		$active_plugins = get_option('active_plugins');
		return $active_plugins;
	}


	public function importDataOfusers($data_array, $mode, $eventKey, $duplicateHandling)
	{
		require_once "class-uci-user-data-import.php";
		$userObj = new SmackUCIUserDataImport();
		$returnArr = $userObj->importUserInformation($data_array, $mode, $eventKey, $duplicateHandling);
		return $returnArr;
	}

	public function importDataOfusersBS($group, $id)
	{
		require_once "class-uci-user-data-import.php";
		$userObj = new SmackUCIUserDataImport();
		$userObj->importDataForUsers_BillingShipping($group, $id);
	}

	public function importDataOfusersWPMem($group, $id)
	{
		require_once "class-uci-user-data-import.php";
		$userObj = new SmackUCIUserDataImport();
		$userObj->importDataForUsers_WPMembers($group, $id);
	}

}
