<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package aaa
 */

?>
<!doctype html>
<html <?php language_attributes(); ?>>
<head>
	
	<!-- Google tag (gtag.js) -->
	<script async src="https://www.googletagmanager.com/gtag/js?id=G-XY3WYECEY3"></script>
	<script>
 	 	window.dataLayer = window.dataLayer || [];
  		function gtag(){dataLayer.push(arguments);}
 		gtag('js', new Date());

  		gtag('config', 'G-XY3WYECEY3');
	</script>
	<!-- Fin Google tag (gtag.js) -->
	
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="https://gmpg.org/xfn/11">
	
	<link rel="preconnect" href="https://fonts.googleapis.com">
	<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
	<link href="https://fonts.googleapis.com/css2?family=Dosis:wght@200;600;800&family=Quicksand:wght@300;700&display=swap" rel="stylesheet">

	<?php wp_head(); ?>
	
</head>

<body <?php body_class(); ?>>
<?php wp_body_open(); ?>


	
<div id="page" class="site">
	<a class="skip-link screen-reader-text" href="#primary"><?php esc_html_e( 'Skip to content', 'aaa' ); ?></a>

	<div class="rectangles-couleurs alignfull">
	  <div class="couleur-fond-saint-urfold"></div>
	  <div class="couleur-fond-le-penity"></div>
	  <div class="couleur-fond-immaculee-conception"></div>
	  <div class="couleur-fond-sainte-marguerite"></div>
	  <div class="couleur-fond-saint-yves-du-bergot"></div>
	  <div class="couleur-fond-loc-maze"></div>
	  <div class="couleur-fond-guicquelleau"></div>
	  <div class="couleur-fond-saint-maudez"></div>
	  <div class="couleur-fond-locmaria"></div>
	  <div class="couleur-fond-lanorven"></div>
    </div>	<!-- .rectangles-couleurs -->
	
	<header id="masthead" class="site-header">	
		
		
	    <div class="site-branding">
            <a href="/"><img src="<?php echo get_stylesheet_directory_uri(); ?>/design/logo-acbl.svg" alt="TITRE DU SITE" onerror="this.removeAttribute('onerror'); this.src='<?php echo get_stylesheet_directory_uri(); ?>/design/logo-acbl.png'"/></a>
			<div class="site-branding-texte">				
			<h1>
				L'art dans les chapelles du Léon
				<br><span>Arz e chapeliou bro Leon</span>
			</h1>
			
			</div> <!--.site-branding-texte-->
		</div><!-- .site-branding -->
		
		
		<nav id="menu-en-tete" class="menu-general">
            <input type="checkbox" class="menu-checkbox" id="menu-checkbox" />
			<label for="menu-checkbox" class="menu-toggle">&equiv; Menu</label>
			
			<?php
			wp_nav_menu(
				array(
					'container' => 'false',
					'theme_location' => 'menu-1',
					'menu_id'        => 'ul-menu-en-tete',

				)
			);
			?>
						
		</nav><!-- #menu-en-tete -->
		
		<div class="boutons">		
			<a href="https://www.facebook.com/ACBL29"><img src="<?php echo get_stylesheet_directory_uri(); ?>/design/bouton-facebook.svg" alt="Facebook" onerror="this.removeAttribute('onerror'); this.src='<?php echo get_stylesheet_directory_uri(); ?>/design/bouton-facebook.png'"/></a>
		</div><!-- .boutons -->
		
		<div style="clear:both"></div>
		

	</header><!-- #masthead -->
