<?php

add_action( 'wp_enqueue_scripts', 'theme_enqueue_styles' );
function theme_enqueue_styles() {
    wp_enqueue_style( 'parent-style', get_template_directory_uri() . '/style.css' );

}

/**
Enlever la barre d'administration
 */
function my_function_admin_bar(){
    return false;
}
add_filter( 'show_admin_bar' , 'my_function_admin_bar');



/**
Enlever les polices chargées par Twenty Sixteen
 */
add_action( 'wp_enqueue_scripts', 'theme_enqueue_styles' );

function wp_dequeue_google_fonts() {
    wp_dequeue_style( 'twentysixteen-fonts' );
}
add_action( 'wp_enqueue_scripts', 'wp_dequeue_google_fonts', 20 );


// Fonction permettant d'ajouter un champ Extrait sur les pages
function my_excerpt_length($length) {return 15; }
add_filter('excerpt_length', 'my_excerpt_length');
add_action( 'admin_init', create_function('', "return add_post_type_support( 'page', 'excerpt' );") );

// Fonction pour afficher un nombre d'article différent dans les pages category
function nombreParPage($query) {
	if ( is_category() )
	$query->query_vars['posts_per_page'] = 30;
	return $query;
}
add_filter('pre_get_posts', 'nombreParPage');

// Modif de la fonction twentysixteen_entry_meta (qui se trouve sans inc/template_tags pour afficher les tags dans les recettes, comme dans les articles

if ( ! function_exists( 'twentysixteen_entry_meta' ) ) :
	/**
	 * Prints HTML with meta information for the categories, tags.
	 *
	 * Create your own twentysixteen_entry_meta() function to override in a child theme.
	 *
	 * @since Twenty Sixteen 1.0
	 */
	function twentysixteen_entry_meta() {
		if ( 'recipe' === get_post_type() || 'post' === get_post_type()) {
			$author_avatar_size = apply_filters( 'twentysixteen_author_avatar_size', 49 );
			printf(
				'<span class="byline"><span class="author vcard">%1$s<span class="screen-reader-text">%2$s </span> <a class="url fn n" href="%3$s">%4$s</a></span></span>',
				get_avatar( get_the_author_meta( 'user_email' ), $author_avatar_size ),
				_x( 'Author', 'Used before post author name.', 'twentysixteen' ),
				esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ),
				get_the_author()
			);
		}

		if ( in_array( get_post_type(), array( 'post', 'attachment', 'recipe') ) ) {
			twentysixteen_entry_date();
		}

		$format = get_post_format();
		if ( current_theme_supports( 'post-formats', $format ) ) {
			printf(
				'<span class="entry-format">%1$s<a href="%2$s">%3$s</a></span>',
				sprintf( '<span class="screen-reader-text">%s </span>', _x( 'Format', 'Used before post format.', 'twentysixteen' ) ),
				esc_url( get_post_format_link( $format ) ),
				get_post_format_string( $format )
			);
		}

		if ( 'recipe' === get_post_type() || 'post' === get_post_type()) {
			twentysixteen_entry_taxonomies();
		}

		if ( ! is_singular() && ! post_password_required() && ( comments_open() || get_comments_number() ) ) {
			echo '<span class="comments-link">';
			comments_popup_link( sprintf( __( 'Leave a comment<span class="screen-reader-text"> on %s</span>', 'twentysixteen' ), get_the_title() ) );
			echo '</span>';
		}
	}
endif;



//retire la mention "privé / protégé" des titres WordPress
add_filter('private_title_format', 'removePrivatePrefix'); 
add_filter('protected_title_format', 'removePrivatePrefix');
function removePrivatePrefix($format) {
return '%s';
}

// Woo commerce pour enlever un moyen de paiement à certains articles (utilisé pour proposer le paiement à la livraison aux libraires uniquement : d'abord, on l'enlève aux produits normaux, ensuite on va essayer d'enlever le paiement par carte "payline" et par chèque "cheque" aux produits destinés aux libraires)

/**
 * @snippet       Disable Payment Method for Specific Category
 * @how-to        Watch tutorial @ https://businessbloomer.com/?p=19055
 * @author        Rodolfo Melogli
 * @compatible    WC 3.6.5
 * @donate $9     https://businessbloomer.com/bloomer-armada/
 */
  
add_filter( 'woocommerce_available_payment_gateways', 'bbloomer_unset_gateway_by_category' );
  
function bbloomer_unset_gateway_by_category( $available_gateways ) {
    if ( is_admin() ) return $available_gateways;
    if ( ! is_checkout() ) return $available_gateways;
    $unset = false;
    $category_ids = array( 775 );
    foreach ( WC()->cart->get_cart_contents() as $key => $values ) {
        $terms = get_the_terms( $values['product_id'], 'product_cat' );    
        foreach ( $terms as $term ) {        
            if ( in_array( $term->term_id, $category_ids ) ) {
                $unset = true;
                break;
            }
        }
    }
    if ( $unset == true ) unset( $available_gateways['cod'] );
    return $available_gateways;
}

add_filter( 'woocommerce_available_payment_gateways', 'bbloomer_unset_cheque' );
  
function bbloomer_unset_cheque( $available_gateways ) {
    if ( is_admin() ) return $available_gateways;
    if ( ! is_checkout() ) return $available_gateways;
    $unset = false;
    $category_ids = array( 777 );
    foreach ( WC()->cart->get_cart_contents() as $key => $values ) {
        $terms = get_the_terms( $values['product_id'], 'product_cat' );    
        foreach ( $terms as $term ) {        
            if ( in_array( $term->term_id, $category_ids ) ) {
                $unset = true;
                break;
            }
        }
    }
    if ( $unset == true ) {
    	unset( $available_gateways['cheque'] );
    	unset( $available_gateways['payline'] );    	
    }
    return $available_gateways;
}
// FIN Woo commerce pour enlever un moyen de paiement à certains articles

// Woocommerce Change le texte 'Ajouter au panier' sur la page de produit unique
add_filter( 'woocommerce_product_single_add_to_cart_text', 'bryce_add_to_cart_text' );
function bryce_add_to_cart_text() {
return __( 'J’achète', 'woocommerce' );
	}
// FIN Woocommerce Change le texte 'Ajouter au panier' sur la page de produit unique
