<?php
/**
 * Kiwiz
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Open Software License (OSL 3.0)
 * that is available through the world-wide-web at the following URI:
 * https://opensource.org/licenses/osl-3.0.php
 * If you did not receive a copy of the PHP License and are unable to
 * obtain it through the web, please send a note to contact@kiwiz.io
 * so we can mail you a copy immediately.
 *
 * @author Kiwiz <contact@kiwiz.io>
 * @license http://opensource.org/licenses/osl-3.0.php Open Software License (OSL 3.0)
 */

defined( 'ABSPATH' ) || exit;

use setasign\Fpdi\Fpdi;

require_once( KIWIZ_PLUGIN_PATH . 'lib/fpdi/fpdi.php' );
require_once( KIWIZ_PLUGIN_PATH . 'lib/fpdi/fpdf.php');

ini_set('max_execution_time', 1800);

/**
 * Class Kiwiz_Concat_Pdf
 */
class Kiwiz_Concat_Pdf extends Fpdi {

    public $files = array();

    public function setFiles($files) {
        $this->files = $files;
    }

    public function concat() {
        foreach($this->files AS $file) {
            $pageCount = $this->setSourceFile($file);
            for ($pageNo = 1; $pageNo <= $pageCount; $pageNo++) {
                $pageId = $this->ImportPage($pageNo);
                $s = $this->getTemplatesize($pageId);
                $this->AddPage($s['orientation'], $s);
                $this->useImportedPage($pageId);
            }
        }
    }
}
