<?php
/*
  Plugin Name: shortcodes pierre
  Description: Plugin fournissant des shortcodes
  Author: Pierre Réguer
  Version: 1.0.0
 */
 
 
 
 
 //Shortcode pour afficher une liste d'articles sous forme de vignettes
 function pierre_liste_articles( $atts, $content = null ) {

	//1. On crée les paramètres utilisables par le shortcode
	$atts = shortcode_atts(
	array(
		'post_type' => 'post',
		'limite' => 'limite',
		'cat' => 'cat',
		'tag_id' => 'tag_id'
		
	), $atts);
	//2. Transforme les paramètres en variables
	extract($atts);
	

	//3. On définit ce qu'on veut pour notre boucle
	$args =  array(
		'post_status' => 'publish',
		'post_type' => $post_type,
		'cat' => $cat,
		'tag_id' => $tag_id,
		'posts_per_page' => $limite,
		'orderby' => 'date',
		'order' => 'DESC',
	);
	
	
	//4. On exécute la query	
	$my_query = new WP_Query($args);
	
	//5. On va stocker le résultat	
	ob_start();

	//6. On lance la boucle
      if($my_query->have_posts()) : while ($my_query->have_posts() ) : $my_query->the_post();

				get_template_part( 'content', 'vignette' );

			endwhile;
			endif;


    //7. On réinitialise à la requête principale (important)
            wp_reset_postdata();
                        
            echo '<p style="clear: both">&nbsp;</p>';

    //8. on déstocke le résultat pour l'afficher            
     return ob_get_clean();

}

    //9. On crée le shortcode            

add_shortcode( 'pierre_liste_articles_shortcode','pierre_liste_articles');