<div class="changelog">
    <div>
        <p class="about-description"><?php echo $name ?> is a very powerful recipe plugin with tons of different settings to suit your needs. Unfortunately this also comes with some complexity.
        Take a few seconds to go though this page and <strong>get started on the right foot</strong>.</p>
    </div>

    <hr />

    <div class="feature-section col two-col">
        <div class="col-1">
            <h3>Recipes vs. Posts</h3>
            <p><strong>Recipes are just like normal posts</strong>. If you want to create a blog post that includes a recipe, just go to <strong>Recipes > Add New</strong>, give it a title, some content and add all the recipe data. The Recipe Box will automatically appear at the bottom of your content.</p>
            <p>Like regular posts your recipes will show up on your homepage and in categories, once published. If they don't, <a href="<?php echo admin_url('edit.php?post_type=recipe&page=wpurp_faq&sub=support'); ?>">contact us</a>!</p>
            <p>If you don't want the Recipe Box at the bottom of the content, just use the <em>[recipe]</em> shortcode to put it wherever you want.</p>
        </div>
        <div class="col-2 last-feature">
            <img src="<?php echo $img_dir; ?>recipe_post.png" alt="Put the Recipe Box wherever you want" class="about-overview-img" />
        </div>
    </div>

    <hr />

    <div class="feature-section col two-col">
        <div class="col-1">
            <img src="<?php echo $img_dir; ?>ingredients.png" alt="Click on our logo to open the Shortcode Editor" class="about-overview-img" />
        </div>
        <div class="col-2 last-feature">
            <h3>Entering Ingredients the right way</h3>
            <p>Ingredients are a crucial part of your recipes, so make sure you enter them the right way.</p>
            <p>Our plugin requires <strong>4 different parts</strong> for each ingredient: the quantity, unit, name and any notes. Use the TAB key while entering to quickly jump between fields and keep adding ingredients.</p>
            <p>Make sure to keep your names consistent as these will be used to link ingredients. It allows your visitors to view all recipes using bacon, for example.</p>
        </div>
    </div>

    <hr />

    <div class="feature-section col two-col">
        <div class="col-1">
            <h3>Adding Recipes to regular posts</h3>
            <p>Recipes should be acting just like regular posts, so you should only add recipes to normal posts if there is a specific reason.</p>
            <p>For example: a post called <em>The very best BBQ recipes for the upcoming summer</em> could include some recipes that you've published before.</p>
            <p>In these situations you can use the <strong>Shortcode Editor</strong> to add recipes to any post or page. Just click on our logo in the visual editor and it will help you create the correct shortcode.</p>
        </div>
        <div class="col-2 last-feature">
            <img src="<?php echo $img_dir; ?>shortcode_editor.png" alt="Click on our logo to open the Shortcode Editor" class="about-overview-img" />
        </div>

    </div>
</div>

<hr />

<div class="changelog under-the-hood">
    <div class="feature-section col three-col">
        <div>
            <h4>Settings</h4>
            <p>Definitely check out the <strong>Recipe > Settings</strong> page as there are a ton of things you can customize to your liking. Take note that some features are only available in the Premium version.</p>
        </div>
        <div>
            <h4>Support</h4>
            <p>There are thousands of different WordPress themes and plugins so there will be compatibility issues. <strong>Just <a href="<?php echo admin_url('edit.php?post_type=recipe&page=wpurp_faq&sub=support'); ?>">contact us</a> and we'll help you out!</strong></p>
        </div>
        <div class="last-feature">
            <h4>Other Documentation?</h4>
            <p>On this page we wanted to show you the essentials. Take a look at <a href="http://www.wpultimaterecipe.com/docs/demo/" target="_blank">our website</a> for more documentation and Video Lessons.</p>
        </div>
    </div>
</div>