<?php		
// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) exit;
require_once  ABSPATH . WPINC . '/category.php';
add_filter('ampforwp_content_module_args','ampforwp_content_module_pagination',10,2);
function ampforwp_content_module_pagination($args, $fieldValues){
  if(isset($fieldValues['pagination']) && $fieldValues['pagination'] == 1 ){
      if( isset($_GET['pageno']) && $_GET['pageno']!=''){
          $paged = intval($_GET['pageno']);
      }else{
          $paged = 1;
      }
      $offset = ( $paged - 1 ) * $args['posts_per_page'] + $args['offset'];
      $args['paged'] = $paged;
      $args['offset'] = $offset;
      
    return $args;
  }else{

    return $args;
  }
}
 $output = '{{if_condition_content_layout_type==1}}
            <div {{if_id}}id="{{id}}"{{ifend_id}} class="pb_mod cat_mod {{user_class}}"><h4>{{content_title}}</h4>   
                <div class="wrap"><ul>{{category_selection}}</ul></div>
                {{pagination_links}}    
            </div>
          {{ifend_condition_content_layout_type_1}}
          ';
 

 $frontCss = '
{{if_condition_content_layout_type==1}}
.wrap{width:100%;display:inline-block;margin-top:10px;}
.cat_mod ul{display: flex;flex-wrap: wrap;margin: -15px;padding:0;list-style-type:none;}
.cat_mod ul li {margin: 15px 15px 25px 15px;flex-basis: calc(33.33% - 30px);}
.cat_mod .cat_mod_l{line-height:0;}
.cat_mod {margin:{{margin_css}};padding:{{padding_css}};}
.cat_mod h4{border-bottom: 2px solid #eee;padding-bottom: 8px;margin-bottom: 5px;font-size:18px;color: #191919;font-weight: 600;}
.cat_mod .cat_mod_r{display:flex;flex-direction: column;margin-top: 6px;}
.cat_mod .cat_mod_r a{font-size: 16px;line-height: 1.3;font-weight: 500;color: #000;margin: 0px 0px 5px 0px;}
.cat_mod .cat_mod_r p{color: {{text_color_picker}};font-size: 13px;line-height: 20px;letter-spacing: 0.10px;margin-bottom:0;}
.cat_mod .cat_mod_l{width:100%;}
.cat_mod .cat_mod_r p a{
  font-size:13px;
  color:#005be2;
}
.pagination a {
    color: black;
    float: left;
    padding: 8px 16px;
    text-decoration: none;
    transition: background-color .3s;
}
.pagination a.active {
    background-color: dodgerblue;
    color: white;
}
.pagination a:hover:not(.active) {background-color: #ddd;}
.pagination{
    width: 100%;
    margin: 30px 0px 0px 0px;
    display: flex;
    flex-wrap: wrap;
    flex-direction: row;
    justify-content: center;
}
@media(max-width:768px){
  .cat_mod ul li {flex-basis: calc(100% - 30px);margin: 10px 15px;}
  .cat_mod_l amp-img{width:100%;}
  .cat_mod .cat_mod_l{width: 40%;float: left;margin-right: 20px;}
  .cat_mod .cat_mod_r{width: 54%;float: left;margin-top: 0;}
}
@media(max-width:767px){
  .pagination a{
    padding:5px 12px;
    font-size:16px;
  }
}
@media (max-width: 480px){
  .cat_mod .cat_mod_l{width: 100%;float: none;margin-right: 0px;}
  .cat_mod .cat_mod_r{width: 100%;float: none;margin-top:6px;}
}
{{ifend_condition_content_layout_type_1}}
';
$options = '<option value="recent_option">Recent Posts</option>';
$post_types = '';
$categoriesArray = array();
if ( is_admin() ) {
  $post_types = get_post_types(array('public'=>true));
  $post_types = get_option('ampforwp_cpt_generated_post_types');
  $post_types['post'] = 'post';
 $categories = get_categories( array(   
                   'orderby' => 'name',   
                   'order'   => 'ASC',
                   'number'  => 500   
               ) );   
 $categoriesArray = array('recent_option'=>'Recent Posts');   
 foreach($categories as $category){   
  $categoryName = htmlspecialchars($category->name, ENT_QUOTES);
  $categoriesArray[$category->term_id] = $categoryName;   
  $options.= '<option value="'.$category->term_id.'">'.$categoryName.'</option>';   
 }    
}
 return array(    
    'label' =>'Category',   
    'name' => 'contents',
    'default_tab'=> 'customizer',
    'tabs' => array(
              'customizer'=>'Content',
              'layout' => 'Layout',
              'container_css'=>'Design',
              'advanced' => 'Advanced'
            ),
    'fields' => array(
            array(    
            'type'    =>'layout-image-picker',
            'name'    =>"content_layout_type",
            'label'   =>"Select Layout",
            'tab'     =>'layout',
            'default' =>'1',    
            'options_details'=>array(
                            array(
                              'value'=>'1',
                              'label'=>'',
                              'demo_image'=> AMPFORWP_PLUGIN_DIR_URI.'/images/cat-dg-1.png'
                            ),
                            
                          ),
            'content_type'=>'html',
            ),
            array(    
            'type'    =>'text',   
            'name'    =>"content_title",    
            'label'   =>'Category Block',
            'tab'     =>'customizer',
            'default' =>'Category', 
            'content_type'=>'html',
            ),
            array(
                'type'    =>'text',
                'name'    =>"id",
                'label'   =>'ID',
                'tab'   =>'advanced',
                'default' =>'',
                'content_type'=>'html'
            ),
            array(
                'type'    =>'text',
                'name'    =>"user_class",
                'label'   =>'Class',
                'tab'   =>'advanced',
                'default' =>'',
                'content_type'=>'html'
              ),
            array(
                'type'    =>'spacing',
                'name'    =>"margin_css",
                'label'   =>'Margin',
                'tab'   =>'advanced',
                'default' =>
                            array(
                                'top'=>'20px',
                                'right'=>'0px',
                                'bottom'=>'20px',
                                'left'=>'0px',
                            ),
                'content_type'=>'css',
              ),
              array(
                'type'    =>'spacing',
                'name'    =>"padding_css",
                'label'   =>'Padding',
                'tab'   =>'advanced',
                'default' =>array(
                          'left'=>'0px',
                          'right'=>'0px',
                          'top'=>'0px',
                          'bottom'=>'0px'
                        ),
                'content_type'=>'css',
              ),
              array(    
              'type'  =>'select',   
              'name'  =>"post_type_selection",   
              'label' =>"Select Post Type",
              'tab'     =>'customizer',
              'default' =>'post',    
              'options' => $post_types,    
              'options_details'=>$post_types ,
              'content_type'=>'html',
              'ajax'  => true,
              'ajax_dep' => 'category_selection',
              'ajax_action' => 'ampforwp_pb_cats'
            ),        
            array(    
              'type'  =>'select',   
              'name'  =>"category_selection",   
              'label' =>"Select Category",
              'tab'     =>'customizer',
              'default' =>'recent_option',    
              'options' => $options,    
              'options_details'=>$categoriesArray ,
              'content_type'=>'html',
            ),    
            array(    
            'type'    =>'text',   
            'name'    =>"show_total_posts",
            'label'   =>'No. of Posts per Page',    
            'tab'     =>'customizer',
            'default' =>'3',
            'content_type'=>'html',
            ),
            array(    
            'type'    =>'text',   
            'name'    =>'posts_offset',
            'label'   => esc_html__('Offset','accelerated-mobile-pages'),  
            'tab'     =>'customizer',
            'default' =>'0',
            'content_type'=>'html',
            ),
            array(    
            'type'    =>'select',
            'name'    =>"ampforwp_show_excerpt",
            'label'   =>"Excerpt",
            'tab'     =>'customizer',
            'default' =>'yes',    
            'options' => '<option value="yes">Yes</option><option value="no">No</option>',    
            'options_details'=>array('yes'=>'Yes', 'no'=>'No'),
            'content_type'=>'html',
            ),
            array(    
            'type'    =>'text',
            'name'    =>"ampforwp_excerpt_length",
            'label'   =>"Excerpt Length",
            'tab'     =>'customizer',
            'default' =>'15',    
            'content_type'=>'html',
            'required'  => array('ampforwp_show_excerpt' => 'yes'),
            ),
            array(    
            'type'    =>'text',
            'name'    =>"ampforwp_read_more",
            'label'   =>esc_html__("Read More Text","accelerated-mobile-pages"),
            'tab'     =>'customizer',
            'default' =>'',    
            'content_type'=>'html',
            'required'  => array('ampforwp_show_excerpt' => 'yes'),
            ),
            array(    
            'type'    =>'text',   
            'name'    =>"img-width-1",    
            'label'   =>'Image Width',
            'tab'     =>'customizer',
            'default' =>'346', 
            'content_type'=>'html',
            'required'  => array('content_layout_type' => 1),
            ),
            array(    
            'type'    =>'text',   
            'name'    =>"img-height-1",    
            'label'   =>'Image Height',
            'tab'     =>'customizer',
            'default' =>'188', 
            'content_type'=>'html',
            'required'  => array('content_layout_type' => 1),
            ),
            array(
                'type'    =>'checkbox_bool',
                'name'    =>"pagination",
                'tab'   =>'customizer',
                'default' => 0,
                'options' =>array(
                        array(
                          'label'=>'Pagination',
                          'value'=>1,
                        ),
                      ),
                'content_type'=>'html',
              ),
            array(    
              'type'    =>'text',   
              'name'    =>"show_no_page_links",    
              'label'   =>'No. of PageLinks to Show',
              'tab'     =>'customizer',
              'default' => 5, 
              'content_type'=>'html',
              'required'  => array('pagination' => 1),
            ),

            
          ),    
    'front_template'=> $output,
    'front_css'=>$frontCss,
    'front_common_css'=>'', 
    'front_loop_content'=>'  {{if_condition_content_layout_type==1}}
                          <li> 

                              <div class="cat_mod_l"> 
                               <a href="{{ampforwp_post_url}}">
                               {{if_image}}<amp-img  class="ampforwp_wc_shortcode_img"  src="{{image}}" width="{{width}}" height="{{height}}" layout="responsive" alt="{{image_alt}}"> </amp-img>{{ifend_image}}</a>
                              </div>
                              <div class="cat_mod_r">
                                <a href="{{ampforwp_post_url}}">{{title}}</a>
                                {{excerptContent}}
                                {{loopdate}}
                                </div>
                            </li></a> 
                       {{ifend_condition_content_layout_type_1}}


                      
                          ',
 );   
 function ampforwp_contentHtml($the_query,$fieldValues,$loopHtml){  
  $contenthtml = '';    
  $ampforwp_show_excerpt = (isset($fieldValues['ampforwp_show_excerpt'])? $fieldValues['ampforwp_show_excerpt']: 'yes');
  $ampforwp_excerpt_length = (isset($fieldValues['ampforwp_excerpt_length'])? $fieldValues['ampforwp_excerpt_length']: 15);
  $ampforwp_excerpt_length = (int) $ampforwp_excerpt_length;
  
  if ( $the_query->have_posts() ) { 
         while ( $the_query->have_posts() ) {   
             $the_query->the_post();    
             $ampforwp_post_url = get_permalink();
             if(ampforwp_get_setting('ampforwp-amp-takeover') == true){ 
             $ampforwp_post_url = trailingslashit($ampforwp_post_url);
             }else{
              $ampforwp_post_url = trailingslashit($ampforwp_post_url) . AMPFORWP_AMP_QUERY_VAR;
             }
             $image = $height = $width = $image_alt = ""; 
             if ( has_post_thumbnail() ) {  
                   $thumb_id = get_post_thumbnail_id();   
                   $image_alt = get_post_meta( $thumb_id, '_wp_attachment_image_alt', true);
                   $thumb_url_array = wp_get_attachment_image_src($thumb_id, 'full', true);  
                   $image = $thumb_url_array[0];
                   $width = $thumb_url_array[1];
                   $height = $thumb_url_array[2];
              }
              if(ampforwp_is_custom_field_featured_image() && ampforwp_cf_featured_image_src()){
                $image    = ampforwp_cf_featured_image_src();
                $width  = ampforwp_cf_featured_image_src('width');
                $height   = ampforwp_cf_featured_image_src('height');
              }
              if(!empty($image) && !empty($width) && !empty($height)){
                  switch($fieldValues['content_layout_type']){
                      case 1:
                        $width = $fieldValues['img-width-1'];
                        $height = $fieldValues['img-height-1'];
                      break;
                      case 2:
                        $width = $fieldValues['img-width-2'];
                        $height = $fieldValues['img-height-2'];
                      break;
                      case 3:
                        $width = $fieldValues['img-width-3'];
                        $height = $fieldValues['img-height-3'];
                      break;
                      case 4:
                        $width = $fieldValues['img-width-4'];
                        $height = $fieldValues['img-height-4'];
                      break;
                      case 5:
                        $width = $fieldValues['img-width-5'];
                        $height = $fieldValues['img-height-5'];
                      break;
                      default:
                      break;
                  }

                  $pb_content_width_height = apply_filters("ampforwp_pb_content_mod_set_height_width", $width, $height, $fieldValues);  
                  if(is_array($pb_content_width_height)){
                    list($new_width, $new_height) = $pb_content_width_height;
                    if ( !empty($new_width) && !empty($new_height) ) {
                      $width = $new_width; 
                      $height = $new_height; 
                    }   
                  }
                  if ( ampforwp_get_setting('ampforwp-retina-images') ) {
                      $resolution = '';
                      $resolution = 2;
                      if(ampforwp_get_setting('ampforwp-retina-images-res')){
                        $resolution = ampforwp_get_setting('ampforwp-retina-images-res');
                      }
                      $width = $width * $resolution;
                      $height = $height * $resolution;
                    }
                    
                  try{
                    if(function_exists('ampforwp_aq_resize')){
                      $thumb_url = ampforwp_aq_resize( $image, $width, $height, true, false ); //resize & crop the image
                     
                      if($thumb_url!=false){
                        $image   =  $thumb_url[0];
                        $width   =  $thumb_url[1];
                        $height  =  $thumb_url[2];
                      }
                    }

                   }catch(Exception $e){
                      error_log($e);
                   }
              }

              $excerptContent = "";
              $readMore = "";
              if( $ampforwp_show_excerpt == 'yes' ) {     
                   if( has_excerpt() ) {    
                     $content = get_the_excerpt();    
                   } else {   
                     $content = get_the_content();    
                   }  
                 if(isset($fieldValues['ampforwp_read_more']) && !empty($fieldValues['ampforwp_read_more']) ){
                    $readMore = $fieldValues['ampforwp_read_more'];
                  }   
                 $excerptContent = '<p>'.wp_trim_words( strip_tags( strip_shortcodes( $content ) ) , (int) $ampforwp_excerpt_length ).'<a href="'.esc_url($ampforwp_post_url).'" > '.esc_html($readMore).'</a></p>';
              }
               $loopdate = "";
               $loopdate =  human_time_diff(
                get_the_time('U', get_the_ID() ), 
                current_time('timestamp') ) .' '. ampforwp_translation( ampforwp_get_setting('amp-translator-ago-date-text'),
                'ago');
               $loopdate = apply_filters('ampforwp_modify_post_date',$loopdate);
               $loopdate = '<p>'.esc_html($loopdate).'</p>';      
               $title = get_the_title();
               $postid = get_the_ID();
               $author = get_the_author();
               $tags = get_the_tags(); 
               if(is_array($tags) && count($tags) > 0){  
                  $tags = $tags[0]->name;  
               }
              // get_the_author_meta( string $field = '', int $user_id = false );
               $postdate = get_the_date(  ' F j, Y', $postid );
              $rawhtml = str_replace(array(
                                "{{ampforwp_post_url}}",
                                "{{image}}",
                                "{{width}}",
                                "{{height}}",
                                "{{title}}",
                                "{{excerptContent}}",
                                "{{readMore}}",
                                "{{loopdate}}",
                                "{{authorname}}",
                                "{{postdate}}",
                                "{{image_alt}}",
                                "{{tags}}"
                                ), 
                              array(
                                $ampforwp_post_url,
                                $image,
                                $width,
                                $height,
                                $title,
                                $excerptContent,
                                $readMore,
                                $loopdate,
                                $author,
                                $postdate,
                                $image_alt,
                                $tags,
                              ), 
                              $loopHtml);
            $rawhtml = ampforwp_replaceIfContentConditional("ampforwp_post_url", $ampforwp_post_url, $rawhtml);
            $rawhtml = ampforwp_replaceIfContentConditional("image", $image, $rawhtml);
            $rawhtml = ampforwp_replaceIfContentConditional("width", $width, $rawhtml);
            $rawhtml = ampforwp_replaceIfContentConditional("height", $height, $rawhtml);
            $rawhtml = ampforwp_replaceIfContentConditional("title", $title, $rawhtml);
            $rawhtml = ampforwp_replaceIfContentConditional("excerptContent", $excerptContent, $rawhtml);
            $rawhtml = ampforwp_replaceIfContentConditional("readMore", $readMore, $rawhtml);
            $rawhtml = ampforwp_replaceIfContentConditional("loopdate", $loopdate, $rawhtml);
            $rawhtml = ampforwp_replaceIfContentConditional("authorname", $author, $rawhtml);
            $rawhtml = ampforwp_replaceIfContentConditional("postdate", $postdate, $rawhtml);
            $rawhtml = ampforwp_replaceIfContentConditional("image_alt", $image_alt, $rawhtml);
            $rawhtml = ampforwp_replaceIfContentConditional("tags", $tags, $rawhtml);
            $rawhtml = apply_filters( 'ampforwp_pb_cntmod_rawhtml', $rawhtml );
            $contenthtml .= $rawhtml;
            
         }    
      
     }
     
     /* Restore original Post Data */   
     wp_reset_postdata();
     $pagination_links = ampforwp_cat_pagination_links($the_query,$fieldValues);
     //echo $contenthtml;
     //die;

     return array('contents'=>$contenthtml,'pagination_links' => $pagination_links);    
 }

 function  ampforwp_cat_pagination_links($the_query,$fieldValues){
        $pagination_links = '';
        $pagination_text = 'pageno';
        if( ampforwp_is_front_page()){
          $queryUrl = esc_url( ampforwp_url_controller(home_url()) );
        }else{
          $queryUrl = esc_url(ampforwp_url_controller(get_permalink(ampforwp_get_the_ID())));
        }
        if( isset($fieldValues['pagination']) && $fieldValues['pagination'] == 1){
      
        /*Pagination Sart*/
        $total_num_pages = $the_query->max_num_pages;
        if(isset($_GET[$pagination_text]) && $_GET[$pagination_text]!='' ){
            $paged = intval($_GET[$pagination_text]);
        }else{
            $paged = 1;
        }
        $pagination_links .= '<div class="pagination">';
        if( $paged > 1){
          
          $first_page = add_query_arg( array( $pagination_text => 1 ), $queryUrl );
          $prev_page = add_query_arg( array( $pagination_text => $paged - 1 ), $queryUrl );

          $pagination_links .= "<a class='pagi-first' href = ".esc_url($first_page)."> ".esc_html__('First','accelerated-mobile-pages')."</a>";
          //$pagination_links .= "<a href = ".$prev_page."> Prev </a>";
        }

        $count = (integer) $fieldValues['show_no_page_links'];
        if( !$count ){
            $count = 3;
        }
        $startPage = max( 1, $paged - $count);
        $endPage = min( $total_num_pages, $paged + $count);
        for($i = $startPage ; $i <= $endPage ; $i++){
          if( $paged == $i){
              $pagination_links .= "<a class='active' href='#/' >".esc_html__($i, 'accelerated-mobile-pages')."</a>";
          }else{
            $allPages = add_query_arg( array( $pagination_text => $i ), $queryUrl );
            $pagination_links .= "<a href =".esc_url($allPages)." >".esc_html__($i, 'accelerated-mobile-pages')."</a>";
          }

        }

        if( $total_num_pages != 1 && $paged < $total_num_pages ){      
          $next_page = add_query_arg( array( $pagination_text => $paged + 1 ), $queryUrl );
          //$pagination_links .= "<a  href =".$next_page." '> Next </a>";
        }
        if( $total_num_pages != $paged ){
          $next_page = add_query_arg( array( $pagination_text => $total_num_pages ), $queryUrl );
          $pagination_links .= "<a class='pagi-last' href =".esc_url($next_page)." >".esc_html__('Last', 'accelerated-mobile-pages')."</a>";
        }
        $pagination_links .= '</div>';
        
        /*Pagination End*/
        }
        return  $pagination_links;
     }