<?php

/* Charge les scripts et les styles */
add_action( 'wp_enqueue_scripts', 'preguer_scripts' );
function preguer_scripts() {
    $version = wp_get_theme()->get( 'Version' );
    wp_enqueue_style( 'preguer-style', get_stylesheet_uri(), array(), $version );
}

/* Prise en charge de fonctions wp */
add_action( 'after_setup_theme', 'preguer_setup' );
function preguer_setup(){
    //add_theme_support( 'title-tag' );
	add_theme_support( 'post-thumbnails' );
	add_theme_support( 'html5', array( 'comment-list', 'comment-form', 'search-form', 'gallery', 'caption', 'style', 'script' ) );

// // Menus
    register_nav_menus(
        array(
            'menu-1' => ( 'Menu principal' ),
            'menu-2' => ( 'Menu mentions légales' ),
        )
    );	
}
/* Charge le le fichier de template tags personnalisés */
include 'inc/template-tags.php';

/* Ajoute un checkbox pour dérouler les sous-menus (Menu wp-cookbook) */
 add_filter( 'walker_nav_menu_start_el' , 'wpcookbook_nav_menu_start_el', 10, 4 );
/**
* Filters the menu item HTML
*
* @param string $output The menu item's starting HTML output.
* @param WP_Post $item The current menu item.
* @param int $depth Depth of menu item. Used for padding.
* @param array $args An object of wp_nav_menu() arguments.
* @return $output The menu item's final HTML output.
*/
function wpcookbook_nav_menu_start_el( $output, $item, $depth, $args ){
$idmenu = $item->ID ;	
if( in_array( 'menu-item-has-children', $item->classes, true ) ) {
$output .= '<input type="checkbox" id="checkbox-'.$idmenu.'" class="sous-menu-checkbox"><label for="checkbox-'.$idmenu.'" class="sous-menu-label screen-reader-text">Sous-menu</label>
';
    }
return $output;
    }


/*Supprime les titres des widgets */
add_filter('widget_title', 'remove_widget_title');
function remove_widget_title() {
return;
}


/* Personnnalise les titres des pages d'archive */
function reguer_modifier_titre_archive( $title, $original_title, $prefix ) {
	//wp_var_dump( $original_title );
	if ( is_category() ) {
		// composer le nouveau titre  
		$title = sprintf( '<span class="surtitre">Voir tous les articles à propos de<br></span> %1$s', $original_title );
	}	
	if ( is_tag() ) {
		// composer le nouveau titre  
		$title = sprintf( '<span class="surtitre">Voir tous les articles à propos de<br></span> %1$s', $original_title );
	}
	return $title;
}
add_filter( 'get_the_archive_title', 'reguer_modifier_titre_archive', 10, 3 );



/** Fonction pour virer jquery **/
add_filter( 'wp_enqueue_scripts', 'change_default_jquery', PHP_INT_MAX );

function change_default_jquery( ){
    wp_dequeue_script( 'jquery');
    wp_deregister_script( 'jquery');   
}
/** Enlever les couleurs personnalisees **/

add_theme_support( 'disable-custom-colors' );


/** Fonction pour autoriser les balises html dans les descriptions de catégories **/
$filters = array('term_description','category_description','pre_term_description');
foreach ( $filters as $filter ) {
    remove_filter($filter, 'wp_filter_kses');
    remove_filter($filter, 'strip_tags');
} 


/** Fonction pour autoriser certaines balises html dans les titres d'articles **/
function autoriser_html_dans_titres( $title ) {
    // Balises autorisées : ajoute ou retire selon tes besoins
    $balises_autorisees = array(
        'br'     => array(),
        'em'     => array(),
        'strong' => array(),
        'i'      => array(),
        'b'      => array(),
        'span'   => array('class' => array()),
    );

    // Nettoie le titre tout en conservant les balises autorisées
    $title = wp_kses( $title, $balises_autorisees );

    // Décodage des entités HTML si WordPress les a échappées
    return html_entity_decode( $title );
}
add_filter( 'the_title', 'autoriser_html_dans_titres', 10, 1 );


/* Déferrer le chargment de tous les js sauf jquery */
function defer_parsing_of_js( $url ) {
    if ( is_user_logged_in() ) return $url; //don't break WP Admin
    if ( FALSE === strpos( $url, '.js' ) ) return $url;
    if ( strpos( $url, 'jquery.js' ) ) return $url;
    return str_replace( ' src', ' defer src', $url );
}
add_filter( 'script_loader_tag', 'defer_parsing_of_js', 10 );