<?php
/*
  Plugin Name: pierre plugin
  Description: Plugin fournissant des fonctions indépendantes du thème
  Author: Pierre Réguer
  Version: 1.0.0
 */

// Fonction permettant d'ajouter un champ Extrait sur les pages
function my_excerpt_length($length) {return 15; }
add_filter('excerpt_length', 'my_excerpt_length');
add_action('admin_init', function() {
	add_post_type_support('page', 'excerpt');
});


// fonction pour désactiver les scripts Google recaptcha sur les pages qui n'en ont pas besoin (code Ezoic)
function disable_google_captcha_except_contact()
{
    if (!is_page(array('contact-cuisine-a-louest'))) {
        wp_dequeue_script('wpcf7-recaptcha');
        wp_dequeue_script('google-recaptcha');
    }
}
add_action('wp_enqueue_scripts', 'disable_google_captcha_except_contact');

/* Fonction pour enlever la génération du titre par Wordpress
add_action('after_setup_theme', 'remove_from_child_theme', 11);
function remove_from_child_theme()
{
    remove_theme_support('title-tag', 'preguer');
}
*/


// Shortcode pour afficher une liste d'articles sous forme de vignettes
function pierre_liste_articles($atts, $content = null)
{
    // On crée les paramètres utilisables par le shortcode
    $atts = shortcode_atts(
        array(
            'post_type' => 'post',
            'limite' => 'limite',
            'cat' => 'cat',
            'tag_id' => 'tag_id',
            'recherche' => 's',
        ),
        $atts
    );
    // Transforme les paramètres en variables
    extract($atts);

    // On définit ce qu'on veut pour notre boucle
    $args =  array(
        'post_status' => 'publish',
        'post_type' => $post_type,
        'cat' => $cat,
        'tag_id' => $tag_id,
        's' => $recherche,
        'posts_per_page' => $limite,
        'orderby' => 'date',
        'order' => 'DESC',
        'post__not_in' => [get_the_ID()]
    );

    // On exécute la query
    $my_query = new WP_Query($args);

    // On va stocker le résultat
    ob_start();

    // On lance la boucle
    if ($my_query->have_posts()) :
        while ($my_query->have_posts()) :
            $my_query->the_post();
            get_template_part('template-parts/content', 'vignette');
        endwhile;
    endif;

    // On réinitialise à la requête principale (important)
    wp_reset_postdata();

    echo '<p style="clear: both">&nbsp;</p>';

    // On déstocke le résultat pour l'afficher
    return ob_get_clean();
}

// On crée le shortcode
add_shortcode('pierre_liste_articles_shortcode', 'pierre_liste_articles');

