<?php
/**
 * L'en-tête du thème
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package preguer
 */

?>
<!doctype html>
<html <?php language_attributes(); ?>>
	<head>	
		<!-- Balise title à partir du titre - génération par wp non désactivée  -->
<?php 
	if ( is_front_page() || is_home() ) { 
    	echo "<title>Cuisine à l'Ouest</title>";
		} else {
    	echo '<title>' . wp_get_document_title() . '</title>';
}


//ajout meta description à partir du champ personnalisé description_seo -->
	$description_seo = '';
		if (is_single() && isset($post->ID)) {
    	$description_seo = get_post_meta($post->ID, "description_seo", true);
		}
		if (!empty($description_seo)) {
    		echo '<meta name="description" content="' . esc_attr($description_seo) . '"/>';
		}
		
		?>
		<!-- POUR FACEBOOK -->
		<meta property="og:image" content="<?php the_post_thumbnail_url(); ?>">
		
		
		<meta charset="<?php bloginfo( 'charset' ); ?>">
		<meta name="viewport" content="width=device-width, initial-scale=1">
		
		<?php wp_head(); ?>
		
<!-- Script Google adsense annonces auto --> 
		<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
		<script>
     		(adsbygoogle = window.adsbygoogle || []).push({
          	google_ad_client: "ca-pub-7582585553970291",
          	enable_page_level_ads: true
     		});
		</script>
<!--fin script Google adsense annonces auto -->
	
	
<!-- Google tag (gtag.js) -->
<script async src="https://www.googletagmanager.com/gtag/js?id=UA-61485929-1"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());

  gtag('config', 'UA-61485929-1');
</script>
		
	</head>

	<body <?php body_class(); ?>>
	<?php wp_body_open(); ?>	
		<div id="page" class="site">
			<a class="skip-link screen-reader-text" href="#primary">Aller au contenu</a>
			
			<header class="entete">	
									
				
				<div class="site-branding">
                        <a class="logo" href="/index.php">
                            <img src="<?php echo get_stylesheet_directory_uri(); ?>/design/logo-cuisinealouest.svg" alt="Logo du site" onerror="this.removeAttribute('onerror'); this.src='<?php echo get_stylesheet_directory_uri(); ?>/design/logo-cuisinealouest.png'">
                            <p class="site-title screen-reader-text">Logo de Cuisine à l'Ouest</p>
                        </a>      

                </div> <!-- #site-branding -->				
				
				<nav id="menu-en-tete" class="menu-general" aria-label="Menu principal">
            		<input type="checkbox" class="menu-checkbox" id="menu-checkbox" />
					<label for="menu-checkbox" class="menu-toggle">MENU</label>
			
					<?php
						wp_nav_menu(
							array(
							'container'      => 'false',
							'theme_location' => 'menu-1',
							'menu_id'        => 'ul-menu-en-tete',
							'depth' 		 => '4',
								
							)
						);
					?>
				</nav><!-- #site-navigation -->		

			
			</header>
			
			<?php if ( !is_page( 'rechercher-sur-cuisine-a-louest') ): ?>
			<div class="blocs-en-tete">
				<div class="form-recherche">
					<form role="search" method="get" class="search-form" action="<?php echo esc_url( home_url( '/' ) ); ?>">
						<label><input type="search" class="recherche-formulaire" placeholder="Recherche…" value="<?php echo get_search_query(); ?>" name="s"></label><button type="submit" class="recherche-bouton"></button>
					</form>
					<div class="lien-recherche"><a href="">Recherche avancée</a></div>					
				</div> <!-- fin form-recherche -->
				<a id="abonnement" class="bloc-abonnement" href='http://localhost:8888/cuisine2405/newsletter/'>Abonnement newsletter</a>							
			</div>
			<?php endif; ?>
			
			<div id="contenu" class="site-contenu">
				
				
				