<?php
/**
 * The output of the "Advanced Sidebar Pages Menu" widget
 *
 * @since   8.0.0
 *
 * To edit copy this file to a folder in your theme called 'advanced-sidebar-menu' and edit at will.
 *
 * @notice  Do not edit this file in its original location, or it will break on upgrade.
 *
 * @package advanced-sidebar-menu
 */

use Advanced_Sidebar_Menu\List_Pages;
use Advanced_Sidebar_Menu\Menus\Page;

$current_menu = Page::get_current();
$list_pages = List_Pages::factory( $current_menu );
$child_pages = $list_pages->get_child_pages( $current_menu->get_top_parent_id(), true );
$content = '';

$current_menu->title();

// Display parent page.
if ( $current_menu->include_parent() ) {
	$content .= '<ul class="parent-sidebar-menu" >';
	$list_args = $list_pages->get_args( Page::LEVEL_PARENT );
	$content .= wp_list_pages( $list_args );
}

if ( ! empty( $child_pages ) ) {
	$content .= '<ul class="child-sidebar-menu">';
	// Child and grandchild pages.
	$content .= $list_pages->list_pages();
	$content .= '</ul><!-- End .child-sidebar-menu -->';
}
if ( $current_menu->include_parent() ) {
	$content .= '</li></ul><!-- End .parent-sidebar-menu -->';
}

return $content;
